/*
 * Decompiled with CFR 0.152.
 */
package com.bulenkov.darcula.ui;

import com.bulenkov.darcula.ui.DarculaSplitPaneUI;
import com.bulenkov.iconloader.IconLoader;
import com.bulenkov.iconloader.util.DoubleColor;
import com.bulenkov.iconloader.util.Gray;
import com.bulenkov.iconloader.util.UIUtil;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.border.Border;
import javax.swing.plaf.basic.BasicSplitPaneDivider;

public class DarculaSplitPaneDivider
extends BasicSplitPaneDivider {
    private Icon splitGlueV = IconLoader.findIcon("/com/bulenkov/darcula/icons/splitGlueV.png", DarculaSplitPaneDivider.class, true);
    private Icon splitGlueH = IconLoader.findIcon("/com/bulenkov/darcula/icons/splitGlueH.png", DarculaSplitPaneDivider.class, true);

    public DarculaSplitPaneDivider(DarculaSplitPaneUI ui) {
        super(ui);
    }

    @Override
    public void paint(Graphics g2) {
        super.paint(g2);
        if (this.splitPane.getOrientation() == 0) {
            this.splitGlueV.paintIcon(this, g2, this.getWidth() / 2, (this.getHeight() - this.splitGlueV.getIconHeight()) / 2);
        } else {
            this.splitGlueH.paintIcon(this, g2, (this.getWidth() - this.splitGlueH.getIconWidth()) / 2, this.getHeight() / 2);
        }
    }

    @Override
    protected JButton createLeftOneTouchButton() {
        JButton b = new JButton(){

            @Override
            public void setBorder(Border b) {
            }

            @Override
            public void paint(Graphics g2) {
                if (DarculaSplitPaneDivider.this.splitPane != null) {
                    int[] xs = new int[3];
                    int[] ys = new int[3];
                    g2.setColor(this.getBackground());
                    g2.fillRect(0, 0, this.getWidth(), this.getHeight());
                    g2.setColor(new DoubleColor(Gray._255, UIUtil.getLabelForeground()));
                    if (DarculaSplitPaneDivider.this.orientation == 0) {
                        int blockSize;
                        xs[0] = blockSize = Math.min(this.getHeight(), 6);
                        xs[1] = 0;
                        xs[2] = blockSize << 1;
                        ys[0] = 0;
                        ys[1] = ys[2] = blockSize;
                        g2.drawPolygon(xs, ys, 3);
                    } else {
                        int blockSize;
                        xs[0] = xs[2] = (blockSize = Math.min(this.getWidth(), 6));
                        xs[1] = 0;
                        ys[0] = 0;
                        ys[1] = blockSize;
                        ys[2] = blockSize << 1;
                    }
                    g2.fillPolygon(xs, ys, 3);
                }
            }

            @Override
            public boolean isFocusTraversable() {
                return false;
            }
        };
        b.setMinimumSize(new Dimension(6, 6));
        b.setCursor(Cursor.getPredefinedCursor(0));
        b.setFocusPainted(false);
        b.setBorderPainted(false);
        b.setRequestFocusEnabled(false);
        return b;
    }

    @Override
    protected JButton createRightOneTouchButton() {
        JButton b = new JButton(){

            @Override
            public void setBorder(Border border) {
            }

            @Override
            public void paint(Graphics g2) {
                if (DarculaSplitPaneDivider.this.splitPane != null) {
                    int[] xs = new int[3];
                    int[] ys = new int[3];
                    g2.setColor(this.getBackground());
                    g2.fillRect(0, 0, this.getWidth(), this.getHeight());
                    if (DarculaSplitPaneDivider.this.orientation == 0) {
                        int blockSize;
                        xs[0] = blockSize = Math.min(this.getHeight(), 6);
                        xs[1] = blockSize << 1;
                        xs[2] = 0;
                        ys[0] = blockSize;
                        ys[2] = 0;
                        ys[1] = 0;
                    } else {
                        int blockSize = Math.min(this.getWidth(), 6);
                        xs[2] = 0;
                        xs[0] = 0;
                        xs[1] = blockSize;
                        ys[0] = 0;
                        ys[1] = blockSize;
                        ys[2] = blockSize << 1;
                    }
                    g2.setColor(new DoubleColor(Gray._255, UIUtil.getLabelForeground()));
                    g2.fillPolygon(xs, ys, 3);
                }
            }

            @Override
            public boolean isFocusTraversable() {
                return false;
            }
        };
        b.setMinimumSize(new Dimension(6, 6));
        b.setCursor(Cursor.getPredefinedCursor(0));
        b.setFocusPainted(false);
        b.setBorderPainted(false);
        b.setRequestFocusEnabled(false);
        return b;
    }
}

