/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.gui.panels;

import cuchaz.enigma.api.service.GuiService;
import cuchaz.enigma.gui.config.UiConfig;
import de.sciss.syntaxpane.actions.ActionUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;

public class GutterPanel
extends JPanel {
    private final JPanel markerPanel;

    public GutterPanel(JEditorPane editor, JComponent lineNumbers) {
        this.markerPanel = new MarkerPanel(editor);
        this.setLayout(new FlowLayout(0, 0, 0));
        this.add(lineNumbers);
        this.add(this.markerPanel);
        this.setBackground(UiConfig.getLineNumbersBackgroundColor());
        this.setForeground(UiConfig.getLineNumbersForegroundColor());
        this.markerPanel.setBackground(UiConfig.getLineNumbersBackgroundColor());
        this.markerPanel.setForeground(UiConfig.getLineNumbersForegroundColor());
        this.setBorder(lineNumbers.getBorder());
        lineNumbers.setBorder(null);
    }

    public void clearMarkers() {
        this.markerPanel.removeAll();
    }

    public void addMarker(int line, GuiService.GutterMarkerAlignment alignment, Component marker) {
        this.markerPanel.add(marker, new MarkerLayout.Constraint(line, alignment));
    }

    private static class MarkerPanel
    extends JPanel
    implements CaretListener,
    DocumentListener,
    PropertyChangeListener {
        private final JEditorPane editor;
        private final Color currentLineColor = UiConfig.getLineNumbersSelectedColor();

        private MarkerPanel(JEditorPane editor) {
            this.editor = editor;
            this.setLayout(new MarkerLayout());
            Insets editorInsets = editor.getInsets();
            if (editorInsets.top != 0 || editorInsets.bottom != 0) {
                this.setBorder(BorderFactory.createEmptyBorder(editorInsets.top, 0, editorInsets.bottom, 0));
            }
            this.setFont(editor.getFont());
            editor.addCaretListener(this);
            editor.getDocument().addDocumentListener(this);
            editor.addPropertyChangeListener(this);
        }

        @Override
        protected void paintComponent(Graphics g) {
            int currentLine;
            super.paintComponent(g);
            try {
                currentLine = ActionUtils.getLineNumber((JTextComponent)this.editor, (int)this.editor.getCaretPosition());
            }
            catch (BadLocationException ex) {
                return;
            }
            FontMetrics fm = this.getFontMetrics(this.getFont());
            int lh = fm.getHeight();
            Insets insets = this.getInsets();
            int y = currentLine * lh;
            g.setColor(this.currentLineColor);
            g.fillRect(0, y, this.getWidth(), lh);
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals("document")) {
                this.repaint();
            }
        }

        @Override
        public void caretUpdate(CaretEvent e) {
            this.repaint();
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.documentChanged();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.documentChanged();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.documentChanged();
        }

        private void documentChanged() {
            SwingUtilities.invokeLater(this::repaint);
        }
    }

    private static class MarkerLayout
    implements LayoutManager2 {
        private static final int GAP = 2;
        private static final int HUGE_HEIGHT = 0x100000;
        private final Map<Component, Constraint> constraints = new HashMap<Component, Constraint>();

        private MarkerLayout() {
        }

        @Override
        public void addLayoutComponent(Component comp, Object constraints) {
            this.constraints.put(comp, (Constraint)constraints);
        }

        @Override
        public Dimension maximumLayoutSize(Container target) {
            return this.preferredLayoutSize(target);
        }

        @Override
        public float getLayoutAlignmentX(Container target) {
            return 0.5f;
        }

        @Override
        public float getLayoutAlignmentY(Container target) {
            return 0.5f;
        }

        @Override
        public void invalidateLayout(Container target) {
        }

        @Override
        public void addLayoutComponent(String name, Component comp) {
        }

        @Override
        public void removeLayoutComponent(Component comp) {
            this.constraints.remove(comp);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Dimension preferredLayoutSize(Container parent) {
            Object object = parent.getTreeLock();
            synchronized (object) {
                Insets insets = parent.getInsets();
                if (this.constraints.isEmpty()) {
                    return new Dimension(insets.left + insets.right, 0x100000);
                }
                HashMap<Integer, Integer> leftCount = new HashMap<Integer, Integer>();
                HashMap<Integer, Integer> rightCount = new HashMap<Integer, Integer>();
                for (Constraint constraint : this.constraints.values()) {
                    switch (constraint.alignment) {
                        case LEFT: {
                            leftCount.merge(constraint.line, 1, Integer::sum);
                            break;
                        }
                        case RIGHT: {
                            rightCount.merge(constraint.line, 1, Integer::sum);
                        }
                    }
                }
                int maxLeft = leftCount.values().stream().mapToInt(Integer::intValue).max().orElse(0);
                int maxRight = rightCount.values().stream().mapToInt(Integer::intValue).max().orElse(0);
                int lineHeight = parent.getFontMetrics(parent.getFont()).getHeight();
                return new Dimension(2 + insets.left + insets.right + (maxLeft + maxRight) * lineHeight, 0x100000);
            }
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            return this.preferredLayoutSize(parent);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void layoutContainer(Container parent) {
            Object object = parent.getTreeLock();
            synchronized (object) {
                HashMap<Integer, Integer> leftCount = new HashMap<Integer, Integer>();
                HashMap<Integer, Integer> rightCount = new HashMap<Integer, Integer>();
                int lineHeight = parent.getFontMetrics(parent.getFont()).getHeight();
                int numComponents = parent.getComponentCount();
                for (int i = 0; i < numComponents; ++i) {
                    Component comp = parent.getComponent(i);
                    Constraint constraint = this.constraints.get(comp);
                    if (constraint == null) continue;
                    int left = switch (constraint.alignment) {
                        default -> throw new IncompatibleClassChangeError();
                        case GuiService.GutterMarkerAlignment.LEFT -> 2 + (leftCount.merge(constraint.line, 1, Integer::sum) - 1) * lineHeight + 1;
                        case GuiService.GutterMarkerAlignment.RIGHT -> parent.getWidth() - rightCount.merge(constraint.line, 1, Integer::sum) * lineHeight + 1;
                    };
                    comp.setBounds(left, constraint.line * lineHeight + 1, lineHeight - 2, lineHeight - 2);
                }
            }
        }

        private record Constraint(int line, GuiService.GutterMarkerAlignment alignment) {
        }
    }
}

