/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.gui.elements;

import cuchaz.enigma.api.service.GuiService;
import cuchaz.enigma.utils.I18n;
import java.util.function.BooleanSupplier;
import java.util.function.Supplier;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;

public class CustomMenuItem
implements GuiService.MenuItemBuilder {
    private final JMenuItem menuItem;
    private final Supplier<String> translationKey;
    private BooleanSupplier enabledCondition = () -> true;

    public CustomMenuItem(JMenuItem menuItem, Supplier<String> translationKey) {
        this.menuItem = menuItem;
        this.translationKey = translationKey;
        menuItem.setText(translationKey.get());
    }

    public GuiService.MenuItemBuilder setAccelerator(KeyStroke accelerator) {
        this.menuItem.setAccelerator(accelerator);
        return this;
    }

    public GuiService.MenuItemBuilder setEnabledWhen(BooleanSupplier condition) {
        this.enabledCondition = condition;
        return this;
    }

    public GuiService.MenuItemBuilder setAction(Runnable action) {
        this.menuItem.addActionListener(e -> action.run());
        return this;
    }

    public void updateUiState() {
        this.menuItem.setEnabled(this.enabledCondition.getAsBoolean());
        this.menuItem.setText(I18n.translate((String)this.translationKey.get()));
    }

    public void retranslateUi() {
        this.menuItem.setText(I18n.translate((String)this.translationKey.get()));
    }
}

