/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.gui.elements;

import cuchaz.enigma.gui.elements.ValidatableTextField;
import cuchaz.enigma.gui.events.ConvertingTextFieldListener;
import cuchaz.enigma.gui.util.GuiUtil;
import cuchaz.enigma.utils.validation.ParameterizedMessage;
import cuchaz.enigma.utils.validation.Validatable;
import java.awt.GridLayout;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashSet;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.text.Document;

public class ConvertingTextField
implements Validatable {
    private final JPanel ui;
    private final ValidatableTextField textField;
    private final JLabel label;
    private boolean editing = false;
    private boolean editable = true;
    private final Set<ConvertingTextFieldListener> listeners = new HashSet<ConvertingTextFieldListener>();

    public ConvertingTextField(String text) {
        this.ui = new JPanel();
        this.ui.setLayout(new GridLayout(1, 1, 0, 0));
        this.textField = new ValidatableTextField(text);
        this.textField.setFocusTraversalKeysEnabled(false);
        this.textField.putClientProperty("JTextField.selectAllOnFocusPolicy", "never");
        this.label = GuiUtil.unboldLabel(new JLabel(text));
        this.label.setBorder(BorderFactory.createLoweredBevelBorder());
        this.label.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                ConvertingTextField.this.startEditing();
            }
        });
        this.textField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                if (!ConvertingTextField.this.hasChanges()) {
                    ConvertingTextField.this.stopEditing(ConvertingTextFieldListener.StopEditingCause.ABORT);
                }
            }
        });
        this.textField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                switch (e.getKeyCode()) {
                    case 27: {
                        ConvertingTextField.this.stopEditing(ConvertingTextFieldListener.StopEditingCause.ABORT);
                        break;
                    }
                    case 10: {
                        ConvertingTextField.this.stopEditing(ConvertingTextFieldListener.StopEditingCause.DO);
                        break;
                    }
                    case 9: {
                        ConvertingTextField.this.stopEditing(ConvertingTextFieldListener.StopEditingCause.TAB);
                        break;
                    }
                }
            }
        });
        this.ui.add(this.label);
    }

    public void startEditing() {
        if (this.editing || !this.editable) {
            return;
        }
        this.ui.removeAll();
        this.ui.add(this.textField);
        this.editing = true;
        this.ui.validate();
        this.ui.repaint();
        this.textField.requestFocusInWindow();
        this.textField.selectAll();
        this.listeners.forEach(l -> l.onStartEditing(this));
    }

    public void stopEditing(ConvertingTextFieldListener.StopEditingCause cause) {
        if (!this.editing) {
            return;
        }
        if (!this.listeners.stream().allMatch(l -> l.tryStopEditing(this, cause))) {
            return;
        }
        if (cause == ConvertingTextFieldListener.StopEditingCause.ABORT) {
            this.textField.setText(this.label.getText());
        } else {
            this.label.setText(this.textField.getText());
        }
        this.ui.removeAll();
        this.ui.add(this.label);
        this.editing = false;
        this.ui.validate();
        this.ui.repaint();
        this.listeners.forEach(l -> l.onStopEditing(this, cause));
    }

    public void setText(String text) {
        this.stopEditing(ConvertingTextFieldListener.StopEditingCause.ABORT);
        this.label.setText(text);
        this.textField.setText(text);
    }

    public void setEditText(String text) {
        if (!this.editing) {
            return;
        }
        this.textField.setText(text);
    }

    public void setEditable(boolean editable) {
        if (!editable) {
            this.stopEditing(ConvertingTextFieldListener.StopEditingCause.ABORT);
        }
        this.label.setEnabled(editable);
        this.editable = editable;
    }

    public void selectAll() {
        if (!this.editing) {
            return;
        }
        this.textField.selectAll();
    }

    public void selectSubstring(int startIndex) {
        if (!this.editing) {
            return;
        }
        Document doc = this.textField.getDocument();
        if (doc != null) {
            this.selectSubstring(startIndex, doc.getLength());
        }
    }

    public void selectSubstring(int startIndex, int endIndex) {
        if (!this.editing) {
            return;
        }
        this.textField.select(startIndex, endIndex);
    }

    public String getText() {
        if (this.editing) {
            return this.textField.getText();
        }
        return this.label.getText();
    }

    public String getPersistentText() {
        return this.label.getText();
    }

    public boolean hasChanges() {
        if (!this.editing) {
            return false;
        }
        return !this.textField.getText().equals(this.label.getText());
    }

    public void addMessage(ParameterizedMessage message) {
        this.textField.addMessage(message);
    }

    public void clearMessages() {
        this.textField.clearMessages();
    }

    public void addListener(ConvertingTextFieldListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(ConvertingTextFieldListener listener) {
        this.listeners.remove(listener);
    }

    public JPanel getUi() {
        return this.ui;
    }
}

