/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.gui;

import cuchaz.enigma.gui.config.UiConfig;
import de.sciss.syntaxpane.DefaultSyntaxKit;
import de.sciss.syntaxpane.syntaxkits.JavaSyntaxKit;
import de.sciss.syntaxpane.util.Configuration;
import java.awt.Font;

public class EnigmaSyntaxKit
extends JavaSyntaxKit {
    private static Configuration configuration = null;

    public Configuration getConfig() {
        if (configuration == null) {
            this.initConfig(DefaultSyntaxKit.getConfig(JavaSyntaxKit.class));
        }
        return configuration;
    }

    public void initConfig(Configuration baseConfig) {
        configuration = EnigmaSyntaxKit.flattenConfiguration(baseConfig, EnigmaSyntaxKit.class);
        configuration.keySet().removeIf(s -> s.startsWith("Action.") && !s.startsWith("Action.find") && !s.startsWith("Action.goto-line") && !s.startsWith("Action.jump-to-pair") && !s.startsWith("Action.quick-find"));
        configuration.put("Style.KEYWORD", String.format("%d, 0", UiConfig.getHighlightColor().getRGB()));
        configuration.put("Style.KEYWORD2", String.format("%d, 3", UiConfig.getHighlightColor().getRGB()));
        configuration.put("Style.STRING", String.format("%d, 0", UiConfig.getStringColor().getRGB()));
        configuration.put("Style.STRING2", String.format("%d, 1", UiConfig.getStringColor().getRGB()));
        configuration.put("Style.NUMBER", String.format("%d, 1", UiConfig.getNumberColor().getRGB()));
        configuration.put("Style.OPERATOR", String.format("%d, 0", UiConfig.getOperatorColor().getRGB()));
        configuration.put("Style.DELIMITER", String.format("%d, 1", UiConfig.getDelimiterColor().getRGB()));
        configuration.put("Style.TYPE", String.format("%d, 2", UiConfig.getTypeColor().getRGB()));
        configuration.put("Style.TYPE2", String.format("%d, 1", UiConfig.getTypeColor().getRGB()));
        configuration.put("Style.IDENTIFIER", String.format("%d, 0", UiConfig.getIdentifierColor().getRGB()));
        configuration.put("Style.DEFAULT", String.format("%d, 0", UiConfig.getTextColor().getRGB()));
        configuration.put("Style.WARNING", String.format("%d, 0", UiConfig.getTextColor().getRGB()));
        configuration.put("Style.ERROR", String.format("%d, 0", UiConfig.getTextColor().getRGB()));
        configuration.put("LineNumbers.Background", String.format("%d", UiConfig.getLineNumbersBackgroundColor().getRGB()));
        configuration.put("LineNumbers.Foreground", String.format("%d", UiConfig.getLineNumbersForegroundColor().getRGB()));
        configuration.put("LineNumbers.CurrentBack", String.format("%d", UiConfig.getLineNumbersSelectedColor().getRGB()));
        configuration.put("RightMarginColumn", "999");
        configuration.put("Action.quick-find", "cuchaz.enigma.gui.QuickFindAction, menu F");
        Font editorFont = UiConfig.activeUseCustomFonts() ? UiConfig.getEditorFont() : UiConfig.getFallbackEditorFont();
        configuration.put("DefaultFont", UiConfig.encodeFont(editorFont));
    }

    private static Configuration flattenConfiguration(Configuration source, Class<?> configClass) {
        Configuration config = new Configuration(configClass, null);
        for (String p : source.stringPropertyNames()) {
            config.put(p, source.getString(p));
        }
        return config;
    }

    public static void invalidate() {
        configuration = null;
    }
}

