/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.translation.mapping.serde;

import cuchaz.enigma.ProgressListener;
import cuchaz.enigma.translation.mapping.serde.MappingFormat;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.HashSet;
import java.util.Set;
import net.fabricmc.mappingio.MappedElementKind;
import net.fabricmc.mappingio.MappingVisitor;
import net.fabricmc.mappingio.adapter.ForwardingMappingVisitor;

final class ProgressTrackingMappingVisitor
extends ForwardingMappingVisitor {
    private final Set<String> classNames;
    private final ProgressListener progressListener;
    private int progress = 0;

    ProgressTrackingMappingVisitor(MappingVisitor next, Set<String> classNames, ProgressListener progressListener) {
        super(next);
        this.classNames = classNames;
        this.progressListener = progressListener;
    }

    @Override
    public void visitDstName(MappedElementKind targetKind, int namespace, String name) throws IOException {
        if (targetKind == MappedElementKind.CLASS && this.classNames.contains(name)) {
            this.progressListener.step(++this.progress, name);
        }
        super.visitDstName(targetKind, namespace, name);
    }

    static void trackLoadingProgress(MappingVisitor next, Path path, MappingFormat format, ProgressListener progressListener, VisitorWithProgressConsumer consumer) throws IOException {
        if (format != MappingFormat.ENIGMA_DIRECTORY) {
            consumer.accept(next, 1);
        }
        Set<String> classNames = ProgressTrackingMappingVisitor.collectClassNames(path);
        consumer.accept(new ProgressTrackingMappingVisitor(next, classNames, progressListener), classNames.size());
    }

    private static Set<String> collectClassNames(final Path dir) throws IOException {
        final HashSet<String> names = new HashSet<String>();
        Files.walkFileTree(dir, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                String extension = "." + net.fabricmc.mappingio.format.MappingFormat.ENIGMA_FILE.fileExt;
                if (file.getFileName().toString().endsWith(extension)) {
                    String filePath = dir.relativize(file).toString().replace(dir.getFileSystem().getSeparator(), "/");
                    String className = filePath.substring(0, filePath.length() - extension.length());
                    names.add(className);
                }
                return FileVisitResult.CONTINUE;
            }
        });
        return names;
    }

    @FunctionalInterface
    static interface VisitorWithProgressConsumer {
        public void accept(MappingVisitor var1, int var2) throws IOException;
    }
}

