/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.translation.mapping;

import cuchaz.enigma.translation.MappingTranslator;
import cuchaz.enigma.translation.mapping.EntryMapping;
import cuchaz.enigma.translation.mapping.VoidEntryResolver;
import cuchaz.enigma.translation.mapping.tree.EntryTree;
import cuchaz.enigma.translation.mapping.tree.EntryTreeNode;
import cuchaz.enigma.translation.mapping.tree.HashEntryTree;
import cuchaz.enigma.translation.representation.entry.ClassEntry;
import cuchaz.enigma.translation.representation.entry.Entry;
import cuchaz.enigma.translation.representation.entry.FieldEntry;
import cuchaz.enigma.translation.representation.entry.MethodEntry;
import java.util.HashSet;

public class MappingOperations {
    public static EntryTree<EntryMapping> invert(EntryTree<EntryMapping> mappings) {
        MappingTranslator translator = new MappingTranslator(mappings, VoidEntryResolver.INSTANCE);
        HashEntryTree<EntryMapping> result = new HashEntryTree<EntryMapping>();
        for (EntryTreeNode entryTreeNode : mappings) {
            Entry<?> leftEntry = entryTreeNode.getEntry();
            EntryMapping leftMapping = (EntryMapping)entryTreeNode.getValue();
            if (!(leftEntry instanceof ClassEntry || leftEntry instanceof MethodEntry || leftEntry instanceof FieldEntry)) {
                result.insert(translator.translate(leftEntry), leftMapping);
                continue;
            }
            Entry<?> rightEntry = translator.translate(leftEntry);
            result.insert(rightEntry, leftMapping == null ? null : leftMapping.withName(leftEntry.getName()));
        }
        return result;
    }

    public static EntryTree<EntryMapping> compose(EntryTree<EntryMapping> left, EntryTree<EntryMapping> right, boolean keepLeftOnly, boolean keepRightOnly) {
        MappingTranslator leftTranslator = new MappingTranslator(left, VoidEntryResolver.INSTANCE);
        HashEntryTree<EntryMapping> result = new HashEntryTree<EntryMapping>();
        HashSet addedMappings = new HashSet();
        for (EntryTreeNode entryTreeNode : left) {
            Entry<?> entry = entryTreeNode.getEntry();
            EntryMapping leftMapping = (EntryMapping)entryTreeNode.getValue();
            Entry<?> rightEntry = leftTranslator.translate(entry);
            EntryMapping rightMapping = (EntryMapping)right.get(rightEntry);
            if (rightMapping != null) {
                result.insert(entry, rightMapping);
                addedMappings.add(rightEntry);
                continue;
            }
            if (!keepLeftOnly) continue;
            result.insert(entry, leftMapping);
        }
        if (keepRightOnly) {
            MappingTranslator leftInverseTranslator = new MappingTranslator(MappingOperations.invert(left), VoidEntryResolver.INSTANCE);
            for (EntryTreeNode entryTreeNode : right) {
                Entry<?> rightEntry = entryTreeNode.getEntry();
                EntryMapping rightMapping = (EntryMapping)entryTreeNode.getValue();
                if (addedMappings.contains(rightEntry)) continue;
                result.insert(leftInverseTranslator.translate(rightEntry), rightMapping);
            }
        }
        return result;
    }
}

