/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.classprovider;

import cuchaz.enigma.analysis.IndexClassWriter;
import cuchaz.enigma.analysis.index.EntryIndex;
import cuchaz.enigma.classprovider.ClassProvider;
import java.util.Collection;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.tree.ClassNode;

public class AddFramesIfNecessaryClassProvider
implements ClassProvider {
    private final ClassProvider delegate;
    private final EntryIndex entryIndex;

    public AddFramesIfNecessaryClassProvider(ClassProvider delegate, EntryIndex entryIndex) {
        this.delegate = delegate;
        this.entryIndex = entryIndex;
    }

    @Override
    public Collection<String> getClassNames() {
        return this.delegate.getClassNames();
    }

    @Override
    @Nullable
    public ClassNode get(String name) {
        ClassNode clazz = this.delegate.get(name);
        if (clazz == null) {
            return null;
        }
        if (clazz.version >= 51) {
            return clazz;
        }
        IndexClassWriter cw = new IndexClassWriter(this.entryIndex, 2);
        clazz.accept(cw);
        ClassReader cr = new ClassReader(cw.toByteArray());
        ClassNode node = new ClassNode();
        cr.accept(node, 0);
        return node;
    }
}

