/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma;

import cuchaz.enigma.Enigma;
import cuchaz.enigma.ProgressListener;
import cuchaz.enigma.analysis.EntryReference;
import cuchaz.enigma.analysis.index.JarIndex;
import cuchaz.enigma.api.DataInvalidationEvent;
import cuchaz.enigma.api.DataInvalidationListener;
import cuchaz.enigma.api.service.DecompilerInputTransformerService;
import cuchaz.enigma.api.service.NameProposalService;
import cuchaz.enigma.api.service.ObfuscationTestService;
import cuchaz.enigma.api.view.ProjectView;
import cuchaz.enigma.api.view.entry.EntryView;
import cuchaz.enigma.bytecode.translators.TranslationClassVisitor;
import cuchaz.enigma.classprovider.ClassProvider;
import cuchaz.enigma.classprovider.ObfuscationFixClassProvider;
import cuchaz.enigma.source.Decompiler;
import cuchaz.enigma.source.DecompilerService;
import cuchaz.enigma.source.SourceSettings;
import cuchaz.enigma.translation.ObfuscatingTranslator;
import cuchaz.enigma.translation.ProposingTranslator;
import cuchaz.enigma.translation.Translatable;
import cuchaz.enigma.translation.Translator;
import cuchaz.enigma.translation.mapping.EntryChange;
import cuchaz.enigma.translation.mapping.EntryMapping;
import cuchaz.enigma.translation.mapping.EntryRemapper;
import cuchaz.enigma.translation.mapping.MappingsChecker;
import cuchaz.enigma.translation.mapping.tree.DeltaTrackingTree;
import cuchaz.enigma.translation.mapping.tree.EntryTree;
import cuchaz.enigma.translation.representation.entry.ClassDefEntry;
import cuchaz.enigma.translation.representation.entry.ClassEntry;
import cuchaz.enigma.translation.representation.entry.Entry;
import cuchaz.enigma.translation.representation.entry.LocalVariableEntry;
import cuchaz.enigma.translation.representation.entry.MethodEntry;
import cuchaz.enigma.utils.I18n;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.ClassNode;

public class EnigmaProject
implements ProjectView {
    private final Enigma enigma;
    private final List<Path> jarPaths;
    private final List<Path> libraryPaths;
    private final ClassProvider classProvider;
    private final JarIndex jarIndex;
    private final byte[] jarChecksum;
    private final Set<String> projectClasses;
    private EntryRemapper mapper;
    private Translator proposingTranslator;
    @Nullable
    private ObfuscatingTranslator inverseTranslator;
    private final List<DataInvalidationListener> dataInvalidationListeners = new ArrayList<DataInvalidationListener>();

    public EnigmaProject(Enigma enigma, List<Path> jarPaths, List<Path> libraryPaths, ClassProvider classProvider, Set<String> projectClasses, JarIndex jarIndex, byte[] jarChecksum) {
        if (jarChecksum.length != 20) {
            throw new IllegalArgumentException();
        }
        this.enigma = enigma;
        this.jarPaths = List.copyOf(jarPaths);
        this.libraryPaths = List.copyOf(libraryPaths);
        this.classProvider = classProvider;
        this.jarIndex = jarIndex;
        this.jarChecksum = jarChecksum;
        this.projectClasses = projectClasses;
        this.setMappings(null);
    }

    public void setMappings(EntryTree<EntryMapping> mappings) {
        this.mapper = mappings != null ? EntryRemapper.mapped(this.jarIndex, mappings) : EntryRemapper.empty(this.jarIndex);
        NameProposalService[] nameProposalServices = this.enigma.getServices().get(NameProposalService.TYPE).toArray(new NameProposalService[0]);
        Translator translator = this.proposingTranslator = nameProposalServices.length == 0 ? this.mapper.getDeobfuscator() : new ProposingTranslator(this.mapper, nameProposalServices);
        if (this.inverseTranslator != null) {
            this.inverseTranslator.refreshAll(this.proposingTranslator);
        }
    }

    public Enigma getEnigma() {
        return this.enigma;
    }

    public List<Path> getJarPaths() {
        return this.jarPaths;
    }

    public List<Path> getLibraryPaths() {
        return this.libraryPaths;
    }

    public ClassProvider getClassProvider() {
        return this.classProvider;
    }

    @Override
    public JarIndex getJarIndex() {
        return this.jarIndex;
    }

    public byte[] getJarChecksum() {
        return this.jarChecksum;
    }

    public EntryRemapper getMapper() {
        return this.mapper;
    }

    public void dropMappings(ProgressListener progress) {
        DeltaTrackingTree<EntryMapping> mappings = this.mapper.getObfToDeobf();
        Collection<Entry<?>> dropped = this.dropMappings(mappings, progress);
        for (Entry<?> entry : dropped) {
            mappings.trackChange(entry);
        }
        if (this.inverseTranslator != null) {
            this.inverseTranslator.refreshAll(this.proposingTranslator);
        }
    }

    private Collection<Entry<?>> dropMappings(EntryTree<EntryMapping> mappings, ProgressListener progress) {
        MappingsChecker checker = new MappingsChecker(this.jarIndex, mappings);
        MappingsChecker.Dropped dropped = checker.dropBrokenMappings(progress);
        Map<Entry<?>, String> droppedMappings = dropped.getDroppedMappings();
        for (Map.Entry<Entry<?>, String> mapping : droppedMappings.entrySet()) {
            System.out.println("WARNING: Couldn't find " + String.valueOf(mapping.getKey()) + " (" + mapping.getValue() + ") in jar. Mapping was dropped.");
        }
        return droppedMappings.keySet();
    }

    public boolean isRenamable(Entry<?> obfEntry) {
        if (obfEntry instanceof MethodEntry) {
            MethodEntry obfMethodEntry = (MethodEntry)obfEntry;
            String name = obfMethodEntry.getName();
            String sig = obfMethodEntry.getDesc().toString();
            if (name.equals("clone") && sig.equals("()Ljava/lang/Object;")) {
                return false;
            }
            if (name.equals("equals") && sig.equals("(Ljava/lang/Object;)Z")) {
                return false;
            }
            if (name.equals("finalize") && sig.equals("()V")) {
                return false;
            }
            if (name.equals("getClass") && sig.equals("()Ljava/lang/Class;")) {
                return false;
            }
            if (name.equals("hashCode") && sig.equals("()I")) {
                return false;
            }
            if (name.equals("notify") && sig.equals("()V")) {
                return false;
            }
            if (name.equals("notifyAll") && sig.equals("()V")) {
                return false;
            }
            if (name.equals("toString") && sig.equals("()Ljava/lang/String;")) {
                return false;
            }
            if (name.equals("wait") && sig.equals("()V")) {
                return false;
            }
            if (name.equals("wait") && sig.equals("(J)V")) {
                return false;
            }
            if (name.equals("wait") && sig.equals("(JI)V")) {
                return false;
            }
            ClassDefEntry parent = this.jarIndex.getEntryIndex().getDefinition((ClassEntry)obfMethodEntry.getParent());
            if (parent != null && parent.getSuperClass() != null && parent.getSuperClass().getFullName().equals("java/lang/Enum")) {
                if (name.equals("values") && sig.equals("()[L" + parent.getFullName() + ";")) {
                    return false;
                }
                if (name.equals("valueOf") && sig.equals("(Ljava/lang/String;)L" + parent.getFullName() + ";")) {
                    return false;
                }
            }
        } else if (obfEntry instanceof LocalVariableEntry && !((LocalVariableEntry)obfEntry).isArgument()) {
            return false;
        }
        return this.jarIndex.getEntryIndex().hasEntry(obfEntry);
    }

    public boolean isRenamable(EntryReference<Entry<?>, Entry<?>> obfReference) {
        return obfReference.isNamed() && this.isRenamable(obfReference.getNameableEntry());
    }

    public boolean isObfuscated(Entry<?> entry) {
        String string;
        List<NameProposalService> nameProposalServices;
        String name = entry.getName();
        List<ObfuscationTestService> obfuscationTestServices = this.getEnigma().getServices().get(ObfuscationTestService.TYPE);
        if (!obfuscationTestServices.isEmpty()) {
            for (ObfuscationTestService obfuscationTestService : obfuscationTestServices) {
                if (!obfuscationTestService.testDeobfuscated(entry)) continue;
                return false;
            }
        }
        if (!(nameProposalServices = this.getEnigma().getServices().get(NameProposalService.TYPE)).isEmpty()) {
            for (NameProposalService service : nameProposalServices) {
                if (!service.proposeName(entry, this.mapper).isPresent()) continue;
                return false;
            }
        }
        return (string = this.mapper.deobfuscate(entry).getName()) == null || string.isEmpty() || string.equals(name);
    }

    public JarExport exportRemappedJar(ProgressListener progress) {
        Collection<ClassEntry> classEntries = this.jarIndex.getEntryIndex().getClasses();
        ObfuscationFixClassProvider fixingClassProvider = new ObfuscationFixClassProvider(this.classProvider, this.jarIndex);
        AtomicInteger count = new AtomicInteger();
        progress.init(classEntries.size(), I18n.translate("progress.classes.deobfuscating"));
        Map<String, ClassNode> compiled = classEntries.parallelStream().map(entry -> {
            ClassEntry translatedEntry = this.proposingTranslator.translate(entry);
            progress.step(count.getAndIncrement(), translatedEntry.toString());
            ClassNode node = fixingClassProvider.get(entry.getFullName());
            if (node != null) {
                ClassNode translatedNode = new ClassNode();
                node.accept(new TranslationClassVisitor(this.proposingTranslator, 589824, translatedNode));
                return translatedNode;
            }
            return null;
        }).filter(Objects::nonNull).collect(Collectors.toMap(n -> n.name, Function.identity()));
        return new JarExport(this.mapper, compiled);
    }

    @Override
    public <T extends EntryView> T deobfuscate(T entry) {
        return (T)((EntryView)((Object)this.proposingTranslator.extendedTranslate((Translatable)((Object)entry)).getValue()));
    }

    @Override
    public <T extends EntryView> T obfuscate(T entry) {
        if (this.inverseTranslator == null) {
            throw new IllegalStateException("Must call registerForInverseMappings before calling obfuscate");
        }
        return (T)this.inverseTranslator.extendedTranslate((Entry)entry).getValue();
    }

    @Override
    public void registerForInverseMappings() {
        if (this.inverseTranslator == null) {
            this.inverseTranslator = new ObfuscatingTranslator(this.jarIndex);
            this.inverseTranslator.refreshAll(this.proposingTranslator);
        }
    }

    public void onEntryChange(EntryMapping prevMapping, EntryChange<?> change) {
        if (this.inverseTranslator == null || change.getDeobfName().isUnchanged()) {
            return;
        }
        String newName = change.getDeobfName().isSet() ? change.getDeobfName().getNewValue() : ((Entry)this.proposingTranslator.extendedTranslate(change.getTarget()).getValue()).getName();
        for (Entry<?> equivalentEntry : this.mapper.getObfResolver().resolveEquivalentEntries((Entry<?>)change.getTarget())) {
            this.inverseTranslator.refreshName(equivalentEntry, prevMapping.targetName(), newName);
        }
    }

    @Override
    public Collection<String> getProjectClasses() {
        return this.projectClasses;
    }

    @Override
    @Nullable
    public ClassNode getBytecode(String className) {
        return this.classProvider.get(className);
    }

    @Override
    public void addDataInvalidationListener(DataInvalidationListener listener) {
        this.dataInvalidationListeners.add(listener);
    }

    @Override
    public void invalidateData(final @Nullable Collection<String> classes, final DataInvalidationEvent.InvalidationType type) {
        DataInvalidationEvent event = new DataInvalidationEvent(){

            @Override
            @Nullable
            public Collection<String> getClasses() {
                return classes;
            }

            @Override
            public DataInvalidationEvent.InvalidationType getType() {
                return type;
            }
        };
        this.dataInvalidationListeners.forEach(listener -> listener.onDataInvalidated(event));
    }

    public static final class JarExport {
        private final EntryRemapper mapper;
        private final Map<String, ClassNode> compiled;

        JarExport(EntryRemapper mapper, Map<String, ClassNode> compiled) {
            this.mapper = mapper;
            this.compiled = compiled;
        }

        public void write(Path path, ProgressListener progress) throws IOException {
            progress.init(this.compiled.size(), I18n.translate("progress.jar.writing"));
            try (JarOutputStream out = new JarOutputStream(Files.newOutputStream(path, new OpenOption[0]));){
                AtomicInteger count = new AtomicInteger();
                for (ClassNode node : this.compiled.values()) {
                    progress.step(count.getAndIncrement(), node.name);
                    String entryName = node.name.replace('.', '/') + ".class";
                    ClassWriter writer = new ClassWriter(0);
                    node.accept(writer);
                    out.putNextEntry(new JarEntry(entryName));
                    out.write(writer.toByteArray());
                    out.closeEntry();
                }
            }
        }

        public SourceExport decompile(EnigmaProject project, ProgressListener progress, DecompilerService decompilerService, DecompileErrorStrategy errorStrategy) {
            List<ClassSource> decompiled = this.decompileStream(project, progress, decompilerService, errorStrategy).toList();
            return new SourceExport(decompiled);
        }

        public Stream<ClassSource> decompileStream(EnigmaProject project, ProgressListener progress, DecompilerService decompilerService, DecompileErrorStrategy errorStrategy) {
            List<ClassNode> classes = this.compiled.values().stream().filter(classNode -> classNode.name.indexOf(36) == -1).peek(classNode -> {
                for (DecompilerInputTransformerService transformer : project.enigma.getServices().get(DecompilerInputTransformerService.TYPE)) {
                    transformer.transform((ClassNode)classNode);
                }
            }).toList();
            progress.init(classes.size(), I18n.translate("progress.classes.decompiling"));
            Decompiler decompiler = decompilerService.create(new ClassProvider(){

                @Override
                public Collection<String> getClassNames() {
                    return compiled.keySet();
                }

                @Override
                public ClassNode get(String name) {
                    return compiled.get(name);
                }
            }, new SourceSettings(false, false));
            AtomicInteger count = new AtomicInteger();
            return classes.parallelStream().map(translatedNode -> {
                progress.step(count.getAndIncrement(), translatedNode.name);
                String source = null;
                try {
                    source = this.decompileClass((ClassNode)translatedNode, decompiler);
                }
                catch (Throwable throwable) {
                    switch (errorStrategy.ordinal()) {
                        case 0: {
                            throw throwable;
                        }
                        case 2: {
                            break;
                        }
                        case 1: {
                            StringWriter writer = new StringWriter();
                            throwable.printStackTrace(new PrintWriter(writer));
                            source = writer.toString();
                            break;
                        }
                    }
                }
                if (source == null) {
                    return null;
                }
                return new ClassSource(translatedNode.name, source);
            }).filter(Objects::nonNull);
        }

        private String decompileClass(ClassNode translatedNode, Decompiler decompiler) {
            return decompiler.getSource(translatedNode.name, this.mapper).asString();
        }
    }

    public static enum DecompileErrorStrategy {
        PROPAGATE,
        TRACE_AS_SOURCE,
        IGNORE;

    }

    public static class ClassSource {
        public final String name;
        public final String source;

        ClassSource(String name, String source) {
            this.name = name;
            this.source = source;
        }

        public void writeTo(Path path) throws IOException {
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
            try (BufferedWriter writer = Files.newBufferedWriter(path, new OpenOption[0]);){
                writer.write(this.source);
            }
        }

        public Path resolvePath(Path root) {
            return root.resolve(this.name.replace('.', '/') + ".java");
        }
    }

    public static final class SourceExport {
        public final Collection<ClassSource> decompiled;

        SourceExport(Collection<ClassSource> decompiled) {
            this.decompiled = decompiled;
        }

        public void write(Path path, ProgressListener progress) throws IOException {
            progress.init(this.decompiled.size(), I18n.translate("progress.sources.writing"));
            int count = 0;
            for (ClassSource source : this.decompiled) {
                progress.step(count++, source.name);
                Path sourcePath = source.resolvePath(path);
                source.writeTo(sourcePath);
            }
        }
    }
}

