/*
 * Decompiled with CFR 0.152.
 */
package com.github.swingdpi.util;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.lang.ref.SoftReference;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.UIManager;

public class ScaledIcon
implements Icon {
    protected final Icon delegate;
    protected final float scaleFactor;
    private final AffineTransformOp scaleOperation;
    private SoftReference<ImageIcon> enabledIcon = new SoftReference<Object>(null);
    private SoftReference<ImageIcon> disabledIcon = new SoftReference<Object>(null);

    public ScaledIcon(Icon icon, float scaleFactor) {
        assert (!(icon instanceof ScaledIcon) && !icon.getClass().getSimpleName().contains("ScaledIconUIResource")) : "Icon is a:  " + icon.getClass().getName();
        this.delegate = icon;
        this.scaleFactor = scaleFactor;
        this.scaleOperation = new AffineTransformOp(AffineTransform.getScaleInstance(scaleFactor, scaleFactor), 3);
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        ImageIcon icon;
        if (this.getIconWidth() <= 0 || this.getIconHeight() <= 0) {
            this.delegate.paintIcon(c, g, x, y);
            return;
        }
        boolean renderEnabled = !(c instanceof AbstractButton) || c.isEnabled();
        ImageIcon imageIcon = icon = renderEnabled ? this.enabledIcon.get() : this.disabledIcon.get();
        if (icon == null) {
            icon = new ImageIcon(this.paintToImageThenScale(c));
            if (this.delegate instanceof ImageIcon) {
                if (renderEnabled) {
                    this.enabledIcon = new SoftReference<ImageIcon>(icon);
                } else {
                    if (c instanceof JComponent) {
                        icon = (ImageIcon)UIManager.getLookAndFeel().getDisabledIcon((JComponent)c, icon);
                    }
                    this.disabledIcon = new SoftReference<ImageIcon>(icon);
                }
            }
        }
        icon.paintIcon(c, g, x, y);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BufferedImage paintToImageThenScale(Component c) {
        BufferedImage image = new BufferedImage(this.getIconWidth(), this.getIconHeight(), 2);
        Graphics g2 = null;
        try {
            BufferedImage unscaledImage = new BufferedImage(this.delegate.getIconWidth(), this.delegate.getIconHeight(), 2);
            g2 = unscaledImage.createGraphics();
            this.delegate.paintIcon(c, g2, 0, 0);
            g2.dispose();
            g2 = image.createGraphics();
            ((Graphics2D)g2).drawImage(unscaledImage, this.scaleOperation, 0, 0);
        }
        finally {
            if (g2 != null) {
                g2.dispose();
            }
        }
        return image;
    }

    @Override
    public int getIconWidth() {
        return Math.round((float)this.delegate.getIconWidth() * this.scaleFactor);
    }

    @Override
    public int getIconHeight() {
        return Math.round((float)this.delegate.getIconHeight() * this.scaleFactor);
    }
}

