/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.gui.panels;

import cuchaz.enigma.EnigmaProject;
import cuchaz.enigma.analysis.EntryReference;
import cuchaz.enigma.gui.Gui;
import cuchaz.enigma.gui.elements.ConvertingTextField;
import cuchaz.enigma.gui.events.ConvertingTextFieldListener;
import cuchaz.enigma.gui.util.GuiUtil;
import cuchaz.enigma.gui.util.ScaleUtil;
import cuchaz.enigma.network.ServerPacketHandler;
import cuchaz.enigma.network.packet.Packet;
import cuchaz.enigma.network.packet.RenameC2SPacket;
import cuchaz.enigma.translation.mapping.AccessModifier;
import cuchaz.enigma.translation.mapping.EntryMapping;
import cuchaz.enigma.translation.representation.entry.ClassEntry;
import cuchaz.enigma.translation.representation.entry.Entry;
import cuchaz.enigma.translation.representation.entry.FieldEntry;
import cuchaz.enigma.translation.representation.entry.LocalVariableEntry;
import cuchaz.enigma.translation.representation.entry.MethodEntry;
import cuchaz.enigma.utils.I18n;
import cuchaz.enigma.utils.validation.Validatable;
import cuchaz.enigma.utils.validation.ValidationContext;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.function.Consumer;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class PanelIdentifier {
    private final Gui gui;
    private final JPanel ui;
    private Entry<?> entry;
    private Entry<?> deobfEntry;
    private ConvertingTextField nameField;
    private final ValidationContext vc = new ValidationContext();

    public PanelIdentifier(Gui gui) {
        this.gui = gui;
        this.ui = new JPanel();
        this.ui.setLayout(new GridBagLayout());
        this.ui.setPreferredSize(ScaleUtil.getDimension(0, 120));
        this.ui.setBorder(BorderFactory.createTitledBorder(I18n.translate((String)"info_panel.identifier")));
        this.ui.setEnabled(false);
    }

    public void setReference(Entry<?> entry) {
        this.entry = entry;
        this.refreshReference();
    }

    public boolean startRenaming() {
        if (this.nameField == null) {
            return false;
        }
        this.nameField.startEditing();
        return true;
    }

    public boolean startRenaming(String text) {
        if (this.nameField == null) {
            return false;
        }
        this.nameField.startEditing();
        this.nameField.setEditText(text);
        return true;
    }

    private void onModifierChanged(AccessModifier modifier) {
        this.gui.validateImmediateAction(vc -> this.gui.getController().onModifierChanged((ValidationContext)vc, this.entry, modifier));
    }

    public void refreshReference() {
        this.deobfEntry = this.entry == null ? null : (Entry)this.gui.getController().project.getMapper().deobfuscate(this.entry);
        this.nameField = null;
        TableHelper th = new TableHelper(this.ui, this.entry, this.gui.getController().project);
        th.begin();
        if (this.entry == null) {
            this.ui.setEnabled(false);
        } else {
            this.ui.setEnabled(true);
            if (this.deobfEntry instanceof ClassEntry) {
                ClassEntry ce = (ClassEntry)this.deobfEntry;
                this.nameField = th.addRenameTextField(I18n.translate((String)"info_panel.identifier.class"), ce.getFullName());
                th.addModifierRow(I18n.translate((String)"info_panel.identifier.modifier"), this::onModifierChanged);
            } else if (this.deobfEntry instanceof FieldEntry) {
                FieldEntry fe = (FieldEntry)this.deobfEntry;
                this.nameField = th.addRenameTextField(I18n.translate((String)"info_panel.identifier.field"), fe.getName());
                th.addStringRow(I18n.translate((String)"info_panel.identifier.class"), ((ClassEntry)fe.getParent()).getFullName());
                th.addStringRow(I18n.translate((String)"info_panel.identifier.type_descriptor"), fe.getDesc().toString());
                th.addModifierRow(I18n.translate((String)"info_panel.identifier.modifier"), this::onModifierChanged);
            } else if (this.deobfEntry instanceof MethodEntry) {
                MethodEntry me = (MethodEntry)this.deobfEntry;
                if (me.isConstructor()) {
                    th.addStringRow(I18n.translate((String)"info_panel.identifier.constructor"), ((ClassEntry)me.getParent()).getFullName());
                } else {
                    this.nameField = th.addRenameTextField(I18n.translate((String)"info_panel.identifier.method"), me.getName());
                    th.addStringRow(I18n.translate((String)"info_panel.identifier.class"), ((ClassEntry)me.getParent()).getFullName());
                }
                th.addStringRow(I18n.translate((String)"info_panel.identifier.method_descriptor"), me.getDesc().toString());
                th.addModifierRow(I18n.translate((String)"info_panel.identifier.modifier"), this::onModifierChanged);
            } else if (this.deobfEntry instanceof LocalVariableEntry) {
                LocalVariableEntry lve = (LocalVariableEntry)this.deobfEntry;
                this.nameField = th.addRenameTextField(I18n.translate((String)"info_panel.identifier.variable"), lve.getName());
                th.addStringRow(I18n.translate((String)"info_panel.identifier.class"), lve.getContainingClass().getFullName());
                th.addStringRow(I18n.translate((String)"info_panel.identifier.method"), ((MethodEntry)lve.getParent()).getName());
                th.addStringRow(I18n.translate((String)"info_panel.identifier.index"), Integer.toString(lve.getIndex()));
            } else {
                throw new IllegalStateException("unreachable");
            }
        }
        th.end();
        if (this.nameField != null) {
            this.nameField.addListener(new ConvertingTextFieldListener(){

                @Override
                public void onStartEditing(ConvertingTextField field) {
                    int i = field.getText().lastIndexOf(47);
                    if (i != -1) {
                        field.selectSubstring(i + 1);
                    }
                }

                @Override
                public boolean tryStopEditing(ConvertingTextField field, boolean abort) {
                    if (abort) {
                        return true;
                    }
                    PanelIdentifier.this.vc.reset();
                    PanelIdentifier.this.vc.setActiveElement((Validatable)field);
                    PanelIdentifier.this.validateRename(field.getText());
                    return PanelIdentifier.this.vc.canProceed();
                }

                @Override
                public void onStopEditing(ConvertingTextField field, boolean abort) {
                    if (abort) {
                        return;
                    }
                    PanelIdentifier.this.vc.reset();
                    PanelIdentifier.this.vc.setActiveElement((Validatable)field);
                    PanelIdentifier.this.doRename(field.getText());
                }
            });
        }
        this.ui.validate();
        this.ui.repaint();
    }

    private void validateRename(String newName) {
        this.gui.getController().rename(this.vc, new EntryReference(this.entry, this.deobfEntry.getName()), newName, true, true);
    }

    private void doRename(String newName) {
        this.gui.getController().rename(this.vc, new EntryReference(this.entry, this.deobfEntry.getName()), newName, true);
        if (!this.vc.canProceed()) {
            return;
        }
        this.gui.getController().sendPacket((Packet<ServerPacketHandler>)new RenameC2SPacket(this.entry, newName, true));
    }

    public JPanel getUi() {
        return this.ui;
    }

    private static final class TableHelper {
        private final Container c;
        private final Entry<?> e;
        private final EnigmaProject project;
        private final GridBagConstraints col1;
        private final GridBagConstraints col2;

        public TableHelper(Container c, Entry<?> e, EnigmaProject project) {
            this.c = c;
            this.e = e;
            this.project = project;
            this.col1 = new GridBagConstraints();
            this.col2 = new GridBagConstraints();
            Insets insets = ScaleUtil.getInsets(2, 2, 2, 2);
            this.col1.gridx = 0;
            this.col1.gridy = 0;
            this.col1.insets = insets;
            this.col1.anchor = 17;
            this.col2.gridx = 1;
            this.col2.gridy = 0;
            this.col2.weightx = 1.0;
            this.col2.fill = 2;
            this.col2.insets = insets;
            this.col2.anchor = 17;
        }

        public void begin() {
            this.c.removeAll();
            this.c.setLayout(new GridBagLayout());
        }

        public void addRow(Component c1, Component c2) {
            this.c.add(c1, this.col1);
            this.c.add(c2, this.col2);
            ++this.col1.gridy;
            ++this.col2.gridy;
        }

        public ConvertingTextField addCovertTextField(String c1, String c2) {
            ConvertingTextField textField = new ConvertingTextField(c2);
            this.addRow(new JLabel(c1), textField.getUi());
            return textField;
        }

        public ConvertingTextField addRenameTextField(String c1, String c2) {
            if (this.project.isRenamable(this.e)) {
                return this.addCovertTextField(c1, c2);
            }
            this.addStringRow(c1, c2);
            return null;
        }

        public void addStringRow(String c1, String c2) {
            this.addRow(new JLabel(c1), GuiUtil.unboldLabel(new JLabel(c2)));
        }

        public JComboBox<AccessModifier> addModifierRow(String c1, Consumer<AccessModifier> changeListener) {
            if (!this.project.isRenamable(this.e)) {
                return null;
            }
            JComboBox<AccessModifier> combo = new JComboBox<AccessModifier>(AccessModifier.values());
            EntryMapping mapping = this.project.getMapper().getDeobfMapping(this.e);
            if (mapping != null) {
                combo.setSelectedIndex(mapping.getAccessModifier().ordinal());
            } else {
                combo.setSelectedIndex(AccessModifier.UNCHANGED.ordinal());
            }
            combo.addItemListener(event -> {
                if (event.getStateChange() == 1) {
                    AccessModifier modifier = (AccessModifier)event.getItem();
                    changeListener.accept(modifier);
                }
            });
            this.addRow(new JLabel(c1), combo);
            return combo;
        }

        public void end() {
            this.col1.weighty = 1.0;
            this.c.add((Component)new JPanel(), this.col1);
        }
    }
}

