/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.gui.dialog;

import cuchaz.enigma.gui.Gui;
import cuchaz.enigma.gui.stats.StatsMember;
import cuchaz.enigma.gui.util.ScaleUtil;
import cuchaz.enigma.utils.I18n;
import java.awt.BorderLayout;
import java.util.Arrays;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class StatsDialog {
    public static void show(Gui gui) {
        JFrame frame = new JFrame(I18n.translate((String)"menu.file.stats.title"));
        JPanel checkboxesPanel = new JPanel();
        JPanel buttonPanel = new JPanel();
        frame.setLayout(new BorderLayout());
        frame.add("North", checkboxesPanel);
        frame.add("South", buttonPanel);
        Map<StatsMember, JCheckBox> checkboxes = Arrays.stream(StatsMember.values()).collect(Collectors.toMap(m -> m, m -> {
            JCheckBox checkbox = new JCheckBox(I18n.translate((String)("type." + m.name().toLowerCase(Locale.ROOT))));
            checkboxesPanel.add(checkbox);
            return checkbox;
        }));
        JButton button = new JButton(I18n.translate((String)"menu.file.stats.generate"));
        buttonPanel.add(button);
        button.setEnabled(false);
        button.addActionListener(action -> {
            frame.dispose();
            StatsDialog.generateStats(gui, checkboxes);
        });
        checkboxes.entrySet().forEach(checkbox -> ((JCheckBox)checkbox.getValue()).addActionListener(action -> {
            if (!button.isEnabled()) {
                button.setEnabled(true);
            } else if (checkboxes.entrySet().stream().allMatch(entry -> !((JCheckBox)entry.getValue()).isSelected())) {
                button.setEnabled(false);
            }
        }));
        frame.pack();
        frame.setVisible(true);
        frame.setSize(ScaleUtil.getDimension(500, 120));
        frame.setResizable(false);
        frame.setLocationRelativeTo(gui.getFrame());
    }

    private static void generateStats(Gui gui, Map<StatsMember, JCheckBox> checkboxes) {
        Set<StatsMember> includedMembers = checkboxes.entrySet().stream().filter(entry -> ((JCheckBox)entry.getValue()).isSelected()).map(Map.Entry::getKey).collect(Collectors.toSet());
        if (gui.getController().project != null) {
            gui.getController().openStats(includedMembers);
        }
    }
}

