/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.gui.dialog;

import cuchaz.enigma.gui.Gui;
import cuchaz.enigma.gui.GuiController;
import cuchaz.enigma.gui.search.SearchEntry;
import cuchaz.enigma.gui.search.SearchUtil;
import cuchaz.enigma.gui.util.AbstractListCellRenderer;
import cuchaz.enigma.gui.util.ScaleUtil;
import cuchaz.enigma.translation.Translatable;
import cuchaz.enigma.translation.representation.entry.ClassEntry;
import cuchaz.enigma.translation.representation.entry.Entry;
import cuchaz.enigma.utils.I18n;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class SearchDialog {
    private final JTextField searchField;
    private DefaultListModel<SearchEntryImpl> classListModel;
    private final JList<SearchEntryImpl> classList;
    private final JDialog dialog;
    private final Gui parent;
    private final SearchUtil<SearchEntryImpl> su;
    private SearchUtil.SearchControl currentSearch;

    public SearchDialog(Gui parent) {
        this.parent = parent;
        this.su = new SearchUtil();
        this.dialog = new JDialog(parent.getFrame(), I18n.translate((String)"menu.view.search"), true);
        JPanel contentPane = new JPanel();
        contentPane.setBorder(ScaleUtil.createEmptyBorder(4, 4, 4, 4));
        contentPane.setLayout(new BorderLayout(ScaleUtil.scale(4), ScaleUtil.scale(4)));
        this.searchField = new JTextField();
        this.searchField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                SearchDialog.this.updateList();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                SearchDialog.this.updateList();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                SearchDialog.this.updateList();
            }
        });
        this.searchField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 40) {
                    int next = SearchDialog.this.classList.isSelectionEmpty() ? 0 : SearchDialog.this.classList.getSelectedIndex() + 1;
                    SearchDialog.this.classList.setSelectedIndex(next);
                    SearchDialog.this.classList.ensureIndexIsVisible(next);
                } else if (e.getKeyCode() == 38) {
                    int prev = SearchDialog.this.classList.isSelectionEmpty() ? SearchDialog.this.classList.getModel().getSize() : SearchDialog.this.classList.getSelectedIndex() - 1;
                    SearchDialog.this.classList.setSelectedIndex(prev);
                    SearchDialog.this.classList.ensureIndexIsVisible(prev);
                } else if (e.getKeyCode() == 27) {
                    SearchDialog.this.close();
                }
            }
        });
        this.searchField.addActionListener(e -> this.openSelected());
        contentPane.add((Component)this.searchField, "North");
        this.classListModel = new DefaultListModel();
        this.classList = new JList();
        this.classList.setModel(this.classListModel);
        this.classList.setCellRenderer(new ListCellRendererImpl());
        this.classList.setSelectionMode(0);
        this.classList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() >= 2) {
                    int idx = SearchDialog.this.classList.locationToIndex(mouseEvent.getPoint());
                    SearchEntryImpl entry = (SearchEntryImpl)SearchDialog.this.classList.getModel().getElementAt(idx);
                    SearchDialog.this.openEntry(entry);
                }
            }
        });
        contentPane.add((Component)new JScrollPane(this.classList, 20, 31), "Center");
        JPanel buttonBar = new JPanel();
        buttonBar.setLayout(new FlowLayout(2));
        JButton open = new JButton(I18n.translate((String)"prompt.open"));
        open.addActionListener(event -> this.openSelected());
        buttonBar.add(open);
        JButton cancel = new JButton(I18n.translate((String)"prompt.cancel"));
        cancel.addActionListener(event -> this.close());
        buttonBar.add(cancel);
        contentPane.add((Component)buttonBar, "South");
        this.dialog.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent e) {
                SearchDialog.this.classList.updateUI();
            }
        });
        this.dialog.setContentPane(contentPane);
        this.dialog.setSize(ScaleUtil.getDimension(400, 500));
        this.dialog.setLocationRelativeTo(parent.getFrame());
    }

    public void show() {
        this.su.clear();
        ((Stream)this.parent.getController().project.getJarIndex().getEntryIndex().getClasses().parallelStream().filter(e -> !e.isInnerClass()).map(e -> SearchEntryImpl.from(e, this.parent.getController())).map(SearchUtil.Entry::from).sequential()).forEach(this.su::add);
        this.updateList();
        this.searchField.requestFocus();
        this.searchField.selectAll();
        this.dialog.setVisible(true);
    }

    private void openSelected() {
        SearchEntryImpl selectedValue = this.classList.getSelectedValue();
        if (selectedValue != null) {
            this.openEntry(selectedValue);
        }
    }

    private void openEntry(SearchEntryImpl e) {
        this.close();
        this.su.hit(e);
        this.parent.getController().navigateTo((Entry<?>)e.obf);
        if (e.deobf != null) {
            this.parent.getDeobfPanel().deobfClasses.setSelectionClass(e.deobf);
        } else {
            this.parent.getObfPanel().obfClasses.setSelectionClass(e.obf);
        }
    }

    private void close() {
        this.dialog.setVisible(false);
    }

    private void updateList() {
        if (this.currentSearch != null) {
            this.currentSearch.stop();
        }
        DefaultListModel classListModel = new DefaultListModel();
        this.classListModel = classListModel;
        this.classList.setModel(classListModel);
        this.currentSearch = this.su.asyncSearch(this.searchField.getText(), (idx, e) -> SwingUtilities.invokeLater(() -> classListModel.insertElementAt(e, idx)));
    }

    public void dispose() {
        this.dialog.dispose();
    }

    private static final class ListCellRendererImpl
    extends AbstractListCellRenderer<SearchEntryImpl> {
        private final JLabel mainName;
        private final JLabel secondaryName;

        public ListCellRendererImpl() {
            this.setLayout(new BorderLayout());
            this.mainName = new JLabel();
            this.add((Component)this.mainName, "West");
            this.secondaryName = new JLabel();
            this.secondaryName.setFont(this.secondaryName.getFont().deriveFont(2));
            this.secondaryName.setForeground(Color.GRAY);
            this.add((Component)this.secondaryName, "East");
        }

        @Override
        public void updateUiForEntry(JList<? extends SearchEntryImpl> list, SearchEntryImpl value, int index, boolean isSelected, boolean cellHasFocus) {
            if (value.deobf == null) {
                this.mainName.setText(value.obf.getSimpleName());
                this.mainName.setToolTipText(value.obf.getFullName());
                this.secondaryName.setText("");
                this.secondaryName.setToolTipText("");
            } else {
                this.mainName.setText(value.deobf.getSimpleName());
                this.mainName.setToolTipText(value.deobf.getFullName());
                this.secondaryName.setText(value.obf.getSimpleName());
                this.secondaryName.setToolTipText(value.obf.getFullName());
            }
        }
    }

    private static final class SearchEntryImpl
    implements SearchEntry {
        public final ClassEntry obf;
        public final ClassEntry deobf;

        private SearchEntryImpl(ClassEntry obf, ClassEntry deobf) {
            this.obf = obf;
            this.deobf = deobf;
        }

        @Override
        public List<String> getSearchableNames() {
            if (this.deobf != null) {
                return Arrays.asList(this.obf.getSimpleName(), this.deobf.getSimpleName());
            }
            return Collections.singletonList(this.obf.getSimpleName());
        }

        @Override
        public String getIdentifier() {
            return this.obf.getFullName();
        }

        public String toString() {
            return String.format("SearchEntryImpl { obf: %s, deobf: %s }", this.obf, this.deobf);
        }

        public static SearchEntryImpl from(ClassEntry e, GuiController controller) {
            ClassEntry deobf = (ClassEntry)controller.project.getMapper().deobfuscate((Translatable)e);
            if (deobf.equals(e)) {
                deobf = null;
            }
            return new SearchEntryImpl(e, deobf);
        }
    }
}

