/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.gui.dialog;

import cuchaz.enigma.utils.I18n;
import java.awt.Frame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;

public class ConnectToServerDialog {
    public static Result show(Frame parentComponent) {
        int port;
        JTextField usernameField = new JTextField(System.getProperty("user.name"), 20);
        JPanel usernameRow = new JPanel();
        usernameRow.add(new JLabel(I18n.translate((String)"prompt.connect.username")));
        usernameRow.add(usernameField);
        JTextField ipField = new JTextField(20);
        JPanel ipRow = new JPanel();
        ipRow.add(new JLabel(I18n.translate((String)"prompt.connect.ip")));
        ipRow.add(ipField);
        JTextField portField = new JTextField(String.valueOf(34712), 10);
        JPanel portRow = new JPanel();
        portRow.add(new JLabel(I18n.translate((String)"prompt.port")));
        portRow.add(portField);
        JPasswordField passwordField = new JPasswordField(20);
        JPanel passwordRow = new JPanel();
        passwordRow.add(new JLabel(I18n.translate((String)"prompt.password")));
        passwordRow.add(passwordField);
        int response = JOptionPane.showConfirmDialog(parentComponent, new Object[]{usernameRow, ipRow, portRow, passwordRow}, I18n.translate((String)"prompt.connect.title"), 2);
        if (response != 0) {
            return null;
        }
        String username = usernameField.getText();
        String ip = ipField.getText();
        try {
            port = Integer.parseInt(portField.getText());
        }
        catch (NumberFormatException e) {
            JOptionPane.showMessageDialog(parentComponent, I18n.translate((String)"prompt.port.nan"), I18n.translate((String)"prompt.connect.title"), 0);
            return null;
        }
        if (port < 0 || port >= 65536) {
            JOptionPane.showMessageDialog(parentComponent, I18n.translate((String)"prompt.port.invalid"), I18n.translate((String)"prompt.connect.title"), 0);
            return null;
        }
        char[] password = passwordField.getPassword();
        return new Result(username, ip, port, password);
    }

    public static class Result {
        private final String username;
        private final String ip;
        private final int port;
        private final char[] password;

        public Result(String username, String ip, int port, char[] password) {
            this.username = username;
            this.ip = ip;
            this.port = port;
            this.password = password;
        }

        public String getUsername() {
            return this.username;
        }

        public String getIp() {
            return this.ip;
        }

        public int getPort() {
            return this.port;
        }

        public char[] getPassword() {
            return this.password;
        }
    }
}

