/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.gui;

import com.google.common.io.MoreFiles;
import cuchaz.enigma.EnigmaProfile;
import cuchaz.enigma.gui.Gui;
import cuchaz.enigma.gui.GuiController;
import cuchaz.enigma.gui.config.Config;
import cuchaz.enigma.translation.mapping.serde.MappingFormat;
import cuchaz.enigma.utils.I18n;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionException;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import joptsimple.ValueConverter;

public class Main {
    public static void main(String[] args) throws IOException {
        OptionParser parser = new OptionParser();
        ArgumentAcceptingOptionSpec jar = parser.accepts("jar", "Jar file to open at startup").withRequiredArg().withValuesConvertedBy(PathConverter.INSTANCE);
        ArgumentAcceptingOptionSpec mappings = parser.accepts("mappings", "Mappings file to open at startup").withRequiredArg().withValuesConvertedBy(PathConverter.INSTANCE);
        ArgumentAcceptingOptionSpec profile = parser.accepts("profile", "Profile json to apply at startup").withRequiredArg().withValuesConvertedBy(PathConverter.INSTANCE);
        parser.accepts("help", "Displays help information");
        try {
            OptionSet options = parser.parse(args);
            if (options.has("help")) {
                parser.printHelpOn((OutputStream)System.out);
                return;
            }
            EnigmaProfile parsedProfile = EnigmaProfile.read((Path)((Path)options.valueOf((OptionSpec)profile)));
            I18n.setLanguage((String)Config.getInstance().language);
            Gui gui = new Gui(parsedProfile);
            GuiController controller = gui.getController();
            if (options.has((OptionSpec)jar)) {
                Path jarPath = (Path)options.valueOf((OptionSpec)jar);
                controller.openJar(jarPath).whenComplete((arg_0, arg_1) -> Main.lambda$main$0(options, (OptionSpec)mappings, controller, arg_0, arg_1));
            }
        }
        catch (OptionException e) {
            System.out.println("Invalid arguments: " + e.getMessage());
            System.out.println();
            parser.printHelpOn((OutputStream)System.out);
        }
    }

    private static /* synthetic */ void lambda$main$0(OptionSet options, OptionSpec mappings, GuiController controller, Void v, Throwable t) {
        if (options.has(mappings)) {
            Path mappingsPath = (Path)options.valueOf(mappings);
            if (Files.isDirectory(mappingsPath, new LinkOption[0])) {
                controller.openMappings(MappingFormat.ENIGMA_DIRECTORY, mappingsPath);
            } else if ("zip".equalsIgnoreCase(MoreFiles.getFileExtension((Path)mappingsPath))) {
                controller.openMappings(MappingFormat.ENIGMA_ZIP, mappingsPath);
            } else {
                controller.openMappings(MappingFormat.ENIGMA_FILE, mappingsPath);
            }
        }
    }

    public static class PathConverter
    implements ValueConverter<Path> {
        public static final ValueConverter<Path> INSTANCE = new PathConverter();

        PathConverter() {
        }

        public Path convert(String path) {
            if (path.startsWith("~")) {
                Path dirHome = Paths.get(System.getProperty("user.home"), new String[0]);
                if (path.startsWith("~/")) {
                    return dirHome.resolve(path.substring(2));
                }
                return dirHome.getParent().resolve(path.substring(1));
            }
            return Paths.get(path, new String[0]);
        }

        public Class<? extends Path> valueType() {
            return Path.class;
        }

        public String valuePattern() {
            return "path";
        }
    }
}

