/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.syntaxpane.actions;

import de.sciss.syntaxpane.SyntaxDocument;
import de.sciss.syntaxpane.Token;
import de.sciss.syntaxpane.actions.DefaultSyntaxAction;
import de.sciss.syntaxpane.actions.gui.ComboCompletionDialog;
import de.sciss.syntaxpane.util.StringUtils;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.text.JTextComponent;

public class CompleteWordAction
extends DefaultSyntaxAction {
    private ComboCompletionDialog dlg;
    private Pattern wordsPattern = DEFAULT_WORDS_REGEXP;
    private static final Pattern DEFAULT_WORDS_REGEXP = Pattern.compile("\\w+");

    public CompleteWordAction() {
        super("COMPLETE_WORD");
    }

    @Override
    public void actionPerformed(JTextComponent target, SyntaxDocument sdoc, int dot, ActionEvent e) {
        Token current = sdoc.getWordAt(dot, this.wordsPattern);
        if (current == null) {
            return;
        }
        String cw = current.getString(sdoc);
        target.select(current.start, current.end());
        sdoc.readLock();
        ArrayList<String> matches = new ArrayList<String>();
        Matcher m3 = sdoc.getMatcher(this.wordsPattern, 0, current.start);
        this.addWords(m3, cw, matches);
        m3 = sdoc.getMatcher(this.wordsPattern, current.end(), sdoc.getLength() - current.end());
        this.addWords(m3, cw, matches);
        sdoc.readUnlock();
        if (matches.size() == 0) {
            return;
        }
        if (matches.size() == 1) {
            target.replaceSelection((String)matches.get(0));
            return;
        }
        if (this.dlg == null) {
            this.dlg = new ComboCompletionDialog(target);
        }
        this.dlg.displayFor(cw, matches);
    }

    public void setWordsRegexp(String value) {
        this.wordsPattern = Pattern.compile(value);
    }

    private void addWords(Matcher m3, String abbr, List<String> matches) {
        while (m3 != null && m3.find()) {
            String word = m3.group();
            if (!StringUtils.camelCaseMatch(word, abbr) || matches.contains(word)) continue;
            matches.add(word);
        }
    }
}

