/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.translation.representation;

import com.google.common.collect.Lists;
import cuchaz.enigma.translation.Translatable;
import cuchaz.enigma.translation.Translator;
import cuchaz.enigma.translation.mapping.EntryMap;
import cuchaz.enigma.translation.mapping.EntryMapping;
import cuchaz.enigma.translation.mapping.EntryResolver;
import cuchaz.enigma.translation.representation.TypeDescriptor;
import cuchaz.enigma.translation.representation.entry.ClassEntry;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;

public class MethodDescriptor
implements Translatable {
    private List<TypeDescriptor> argumentDescs;
    private TypeDescriptor returnDesc;

    public MethodDescriptor(String desc) {
        try {
            this.argumentDescs = Lists.newArrayList();
            int i = 0;
            while (i < desc.length()) {
                char c = desc.charAt(i);
                if (c == '(') {
                    assert (this.argumentDescs.isEmpty());
                    assert (this.returnDesc == null);
                    ++i;
                    continue;
                }
                if (c == ')') {
                    ++i;
                    break;
                }
                String type = TypeDescriptor.parseFirst(desc.substring(i));
                this.argumentDescs.add(new TypeDescriptor(type));
                i += type.length();
            }
            this.returnDesc = new TypeDescriptor(TypeDescriptor.parseFirst(desc.substring(i)));
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("Unable to parse method descriptor: " + desc, ex);
        }
    }

    public MethodDescriptor(List<TypeDescriptor> argumentDescs, TypeDescriptor returnDesc) {
        this.argumentDescs = argumentDescs;
        this.returnDesc = returnDesc;
    }

    public List<TypeDescriptor> getArgumentDescs() {
        return this.argumentDescs;
    }

    public TypeDescriptor getReturnDesc() {
        return this.returnDesc;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("(");
        for (TypeDescriptor desc : this.argumentDescs) {
            buf.append(desc);
        }
        buf.append(")");
        buf.append(this.returnDesc);
        return buf.toString();
    }

    public Iterable<TypeDescriptor> types() {
        ArrayList<TypeDescriptor> descs = Lists.newArrayList();
        descs.addAll(this.argumentDescs);
        descs.add(this.returnDesc);
        return descs;
    }

    public boolean equals(Object other) {
        return other instanceof MethodDescriptor && this.equals((MethodDescriptor)other);
    }

    public boolean equals(MethodDescriptor other) {
        return this.argumentDescs.equals(other.argumentDescs) && this.returnDesc.equals(other.returnDesc);
    }

    public int hashCode() {
        return Objects.hash(this.argumentDescs.hashCode(), this.returnDesc.hashCode());
    }

    public boolean hasClass(ClassEntry classEntry) {
        for (TypeDescriptor desc : this.types()) {
            if (!desc.containsType() || !desc.getTypeEntry().equals(classEntry)) continue;
            return true;
        }
        return false;
    }

    public MethodDescriptor remap(Function<String, String> remapper) {
        ArrayList<TypeDescriptor> argumentDescs = new ArrayList<TypeDescriptor>(this.argumentDescs.size());
        for (TypeDescriptor desc : this.argumentDescs) {
            argumentDescs.add(desc.remap(remapper));
        }
        return new MethodDescriptor(argumentDescs, this.returnDesc.remap(remapper));
    }

    @Override
    public MethodDescriptor translate(Translator translator, EntryResolver resolver, EntryMap<EntryMapping> mappings) {
        ArrayList<TypeDescriptor> translatedArguments = new ArrayList<TypeDescriptor>(this.argumentDescs.size());
        for (TypeDescriptor argument : this.argumentDescs) {
            translatedArguments.add(translator.translate(argument));
        }
        return new MethodDescriptor(translatedArguments, translator.translate(this.returnDesc));
    }

    public boolean canConflictWith(MethodDescriptor descriptor) {
        return descriptor.argumentDescs.equals(this.argumentDescs);
    }
}

