/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.translation.mapping.serde.tinyv2;

import cuchaz.enigma.ProgressListener;
import cuchaz.enigma.translation.mapping.EntryMapping;
import cuchaz.enigma.translation.mapping.MappingPair;
import cuchaz.enigma.translation.mapping.serde.MappingParseException;
import cuchaz.enigma.translation.mapping.serde.MappingSaveParameters;
import cuchaz.enigma.translation.mapping.serde.MappingsReader;
import cuchaz.enigma.translation.mapping.serde.RawEntryMapping;
import cuchaz.enigma.translation.mapping.tree.EntryTree;
import cuchaz.enigma.translation.mapping.tree.HashEntryTree;
import cuchaz.enigma.translation.representation.MethodDescriptor;
import cuchaz.enigma.translation.representation.TypeDescriptor;
import cuchaz.enigma.translation.representation.entry.ClassEntry;
import cuchaz.enigma.translation.representation.entry.Entry;
import cuchaz.enigma.translation.representation.entry.FieldEntry;
import cuchaz.enigma.translation.representation.entry.LocalVariableEntry;
import cuchaz.enigma.translation.representation.entry.MethodEntry;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.BitSet;
import java.util.List;

public final class TinyV2Reader
implements MappingsReader {
    private static final String MINOR_VERSION = "0";
    private static final int IN_HEADER = 0;
    private static final int IN_CLASS = 1;
    private static final int IN_METHOD = 2;
    private static final int IN_FIELD = 3;
    private static final int IN_PARAMETER = 4;
    private static final int STATE_SIZE = 5;
    private static final int[] INDENT_CLEAR_START = new int[]{0, 2, 4, 5};
    private static final String TO_ESCAPE = "\\\n\r\u0000\t";
    private static final String ESCAPED = "\\nr0t";

    @Override
    public EntryTree<EntryMapping> read(Path path, ProgressListener progress, MappingSaveParameters saveParameters) throws IOException, MappingParseException {
        return this.read(path, Files.readAllLines(path, StandardCharsets.UTF_8), progress);
    }

    private EntryTree<EntryMapping> read(Path path, List<String> lines, ProgressListener progress) throws MappingParseException {
        HashEntryTree<EntryMapping> mappings = new HashEntryTree<EntryMapping>();
        progress.init(lines.size(), "progress.mappings.tiny_v2.loading");
        BitSet state = new BitSet(5);
        MappingPair[] holds = new MappingPair[5];
        boolean escapeNames = false;
        block48: for (int lineNumber = 0; lineNumber < lines.size(); ++lineNumber) {
            try {
                progress.step(lineNumber, "");
                String line = lines.get(lineNumber);
                int indent = 0;
                while (line.charAt(indent) == '\t') {
                    ++indent;
                }
                String[] parts = line.substring(indent).split("\t", -1);
                if (parts.length == 0 || indent >= INDENT_CLEAR_START.length) {
                    throw new IllegalArgumentException("Invalid format");
                }
                for (int i = INDENT_CLEAR_START[indent]; i < 5; ++i) {
                    EntryMapping baked;
                    state.clear(i);
                    if (holds[i] == null) continue;
                    RawEntryMapping mapping = (RawEntryMapping)holds[i].getMapping();
                    if (mapping != null && (baked = mapping.bake()) != null) {
                        mappings.insert((Entry<?>)holds[i].getEntry(), baked);
                    }
                    holds[i] = null;
                }
                block1 : switch (indent) {
                    case 0: {
                        switch (parts[0]) {
                            case "tiny": {
                                if (lineNumber != 0) {
                                    throw new IllegalArgumentException("Header can only be on the first line");
                                }
                                if (parts.length < 5) {
                                    throw new IllegalArgumentException("Not enough header columns, needs at least 5");
                                }
                                if (!"2".equals(parts[1]) || !MINOR_VERSION.equals(parts[2])) {
                                    throw new IllegalArgumentException("Unsupported TinyV2 version, requires major 2 and minor 0");
                                }
                                state.set(0);
                                break block1;
                            }
                            case "c": {
                                state.set(1);
                                holds[1] = this.parseClass(parts, escapeNames);
                                break block1;
                            }
                        }
                        this.unsupportKey(parts);
                        break;
                    }
                    case 1: {
                        if (state.get(0)) {
                            if (!parts[0].equals("esacpe-names")) continue block48;
                            escapeNames = true;
                            break;
                        }
                        if (state.get(1)) {
                            switch (parts[0]) {
                                case "m": {
                                    state.set(2);
                                    holds[2] = this.parseMethod(holds[1], parts, escapeNames);
                                    break block1;
                                }
                                case "f": {
                                    state.set(3);
                                    holds[3] = this.parseField(holds[1], parts, escapeNames);
                                    break block1;
                                }
                                case "c": {
                                    this.addJavadoc((MappingPair<? extends Entry, RawEntryMapping>)holds[1], parts);
                                    break block1;
                                }
                            }
                            this.unsupportKey(parts);
                            break;
                        }
                        this.unsupportKey(parts);
                    }
                    case 2: {
                        if (state.get(2)) {
                            switch (parts[0]) {
                                case "p": {
                                    state.set(4);
                                    holds[4] = this.parseArgument(holds[2], parts, escapeNames);
                                    break block1;
                                }
                                case "v": {
                                    break block1;
                                }
                                case "c": {
                                    this.addJavadoc((MappingPair<? extends Entry, RawEntryMapping>)holds[2], parts);
                                    break block1;
                                }
                            }
                            this.unsupportKey(parts);
                            break;
                        }
                        if (state.get(3)) {
                            switch (parts[0]) {
                                case "c": {
                                    this.addJavadoc((MappingPair<? extends Entry, RawEntryMapping>)holds[3], parts);
                                    break block1;
                                }
                            }
                            this.unsupportKey(parts);
                            break;
                        }
                        this.unsupportKey(parts);
                    }
                    case 3: {
                        if (state.get(4)) {
                            switch (parts[0]) {
                                case "c": {
                                    this.addJavadoc((MappingPair<? extends Entry, RawEntryMapping>)holds[4], parts);
                                    break block1;
                                }
                            }
                            this.unsupportKey(parts);
                            break;
                        }
                        this.unsupportKey(parts);
                    }
                    default: {
                        this.unsupportKey(parts);
                    }
                }
                continue;
            }
            catch (Throwable t) {
                t.printStackTrace();
                throw new MappingParseException(path::toString, lineNumber + 1, t.toString());
            }
        }
        return mappings;
    }

    private void unsupportKey(String[] parts) {
        throw new IllegalArgumentException("Unsupported key " + parts[0]);
    }

    private void addJavadoc(MappingPair<? extends Entry, RawEntryMapping> pair, String[] parts) {
        if (parts.length != 2) {
            throw new IllegalArgumentException("Invalid javadoc declaration");
        }
        this.addJavadoc(pair, parts[1]);
    }

    private MappingPair<ClassEntry, RawEntryMapping> parseClass(String[] tokens, boolean escapeNames) {
        ClassEntry obfuscatedEntry = new ClassEntry(TinyV2Reader.unescapeOpt(tokens[1], escapeNames));
        if (tokens.length <= 2) {
            return new MappingPair<ClassEntry, RawEntryMapping>(obfuscatedEntry);
        }
        String token2 = TinyV2Reader.unescapeOpt(tokens[2], escapeNames);
        String mapping = token2.substring(token2.lastIndexOf(36) + 1);
        return new MappingPair<ClassEntry, RawEntryMapping>(obfuscatedEntry, new RawEntryMapping(mapping));
    }

    private MappingPair<FieldEntry, RawEntryMapping> parseField(MappingPair<? extends Entry, RawEntryMapping> parent, String[] tokens, boolean escapeNames) {
        ClassEntry ownerClass = (ClassEntry)parent.getEntry();
        TypeDescriptor descriptor = new TypeDescriptor(TinyV2Reader.unescapeOpt(tokens[1], escapeNames));
        FieldEntry obfuscatedEntry = new FieldEntry(ownerClass, TinyV2Reader.unescapeOpt(tokens[2], escapeNames), descriptor);
        if (tokens.length <= 3) {
            return new MappingPair<FieldEntry, RawEntryMapping>(obfuscatedEntry);
        }
        String mapping = TinyV2Reader.unescapeOpt(tokens[3], escapeNames);
        return new MappingPair<FieldEntry, RawEntryMapping>(obfuscatedEntry, new RawEntryMapping(mapping));
    }

    private MappingPair<MethodEntry, RawEntryMapping> parseMethod(MappingPair<? extends Entry, RawEntryMapping> parent, String[] tokens, boolean escapeNames) {
        ClassEntry ownerClass = (ClassEntry)parent.getEntry();
        MethodDescriptor descriptor = new MethodDescriptor(TinyV2Reader.unescapeOpt(tokens[1], escapeNames));
        MethodEntry obfuscatedEntry = new MethodEntry(ownerClass, TinyV2Reader.unescapeOpt(tokens[2], escapeNames), descriptor);
        if (tokens.length <= 3) {
            return new MappingPair<MethodEntry, RawEntryMapping>(obfuscatedEntry);
        }
        String mapping = TinyV2Reader.unescapeOpt(tokens[3], escapeNames);
        return new MappingPair<MethodEntry, RawEntryMapping>(obfuscatedEntry, new RawEntryMapping(mapping));
    }

    private void addJavadoc(MappingPair<? extends Entry, RawEntryMapping> pair, String javadoc) {
        RawEntryMapping mapping = pair.getMapping();
        if (mapping == null) {
            throw new IllegalArgumentException("Javadoc requires a mapping in enigma!");
        }
        mapping.addJavadocLine(TinyV2Reader.unescape(javadoc));
    }

    private MappingPair<LocalVariableEntry, RawEntryMapping> parseArgument(MappingPair<? extends Entry, RawEntryMapping> parent, String[] tokens, boolean escapeNames) {
        MethodEntry ownerMethod = (MethodEntry)parent.getEntry();
        int variableIndex = Integer.parseInt(tokens[1]);
        LocalVariableEntry obfuscatedEntry = new LocalVariableEntry(ownerMethod, variableIndex, "", true, null);
        if (tokens.length <= 3) {
            return new MappingPair<LocalVariableEntry, RawEntryMapping>(obfuscatedEntry);
        }
        String mapping = TinyV2Reader.unescapeOpt(tokens[3], escapeNames);
        return new MappingPair<LocalVariableEntry, RawEntryMapping>(obfuscatedEntry, new RawEntryMapping(mapping));
    }

    private static String unescapeOpt(String raw, boolean escapedStrings) {
        return escapedStrings ? TinyV2Reader.unescape(raw) : raw;
    }

    private static String unescape(String str) {
        int pos = str.indexOf(92);
        if (pos < 0) {
            return str;
        }
        StringBuilder ret = new StringBuilder(str.length() - 1);
        int start = 0;
        do {
            ret.append(str, start, pos);
            if (++pos >= str.length()) {
                throw new RuntimeException("incomplete escape sequence at the end");
            }
            int type = ESCAPED.indexOf(str.charAt(pos));
            if (type < 0) {
                throw new RuntimeException("invalid escape character: \\" + str.charAt(pos));
            }
            ret.append(TO_ESCAPE.charAt(type));
        } while ((pos = str.indexOf(92, start = pos + 1)) >= 0);
        ret.append(str, start, str.length());
        return ret.toString();
    }
}

