/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.network.packet;

import cuchaz.enigma.network.Message;
import cuchaz.enigma.network.ServerPacketHandler;
import cuchaz.enigma.network.packet.Packet;
import cuchaz.enigma.network.packet.PacketHelper;
import cuchaz.enigma.network.packet.RemoveMappingS2CPacket;
import cuchaz.enigma.translation.representation.entry.Entry;
import cuchaz.enigma.utils.validation.PrintValidatable;
import cuchaz.enigma.utils.validation.ValidationContext;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class RemoveMappingC2SPacket
implements Packet<ServerPacketHandler> {
    private Entry<?> entry;

    RemoveMappingC2SPacket() {
    }

    public RemoveMappingC2SPacket(Entry<?> entry) {
        this.entry = entry;
    }

    @Override
    public void read(DataInput input) throws IOException {
        this.entry = PacketHelper.readEntry(input);
    }

    @Override
    public void write(DataOutput output) throws IOException {
        PacketHelper.writeEntry(output, this.entry);
    }

    @Override
    public void handle(ServerPacketHandler handler) {
        ValidationContext vc = new ValidationContext();
        vc.setActiveElement(PrintValidatable.INSTANCE);
        boolean valid = handler.getServer().canModifyEntry(handler.getClient(), this.entry);
        if (valid) {
            handler.getServer().getMappings().removeByObf(vc, this.entry);
            valid = vc.canProceed();
        }
        if (!valid) {
            handler.getServer().sendCorrectMapping(handler.getClient(), this.entry, true);
            return;
        }
        handler.getServer().log(handler.getServer().getUsername(handler.getClient()) + " removed the mapping for " + this.entry);
        int syncId = handler.getServer().lockEntry(handler.getClient(), this.entry);
        handler.getServer().sendToAllExcept(handler.getClient(), new RemoveMappingS2CPacket(syncId, this.entry));
        handler.getServer().sendMessage(Message.removeMapping(handler.getServer().getUsername(handler.getClient()), this.entry));
    }
}

