/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.network.packet;

import cuchaz.enigma.analysis.EntryReference;
import cuchaz.enigma.network.ClientPacketHandler;
import cuchaz.enigma.network.packet.ConfirmChangeC2SPacket;
import cuchaz.enigma.network.packet.Packet;
import cuchaz.enigma.network.packet.PacketHelper;
import cuchaz.enigma.translation.representation.entry.Entry;
import cuchaz.enigma.utils.validation.PrintValidatable;
import cuchaz.enigma.utils.validation.ValidationContext;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class ChangeDocsS2CPacket
implements Packet<ClientPacketHandler> {
    private int syncId;
    private Entry<?> entry;
    private String newDocs;

    ChangeDocsS2CPacket() {
    }

    public ChangeDocsS2CPacket(int syncId, Entry<?> entry, String newDocs) {
        this.syncId = syncId;
        this.entry = entry;
        this.newDocs = newDocs;
    }

    @Override
    public void read(DataInput input) throws IOException {
        this.syncId = input.readUnsignedShort();
        this.entry = PacketHelper.readEntry(input);
        this.newDocs = PacketHelper.readString(input);
    }

    @Override
    public void write(DataOutput output) throws IOException {
        output.writeShort(this.syncId);
        PacketHelper.writeEntry(output, this.entry);
        PacketHelper.writeString(output, this.newDocs);
    }

    @Override
    public void handle(ClientPacketHandler controller) {
        ValidationContext vc = new ValidationContext();
        vc.setActiveElement(PrintValidatable.INSTANCE);
        controller.changeDocs(vc, new EntryReference(this.entry, this.entry.getName()), this.newDocs);
        if (!vc.canProceed()) {
            return;
        }
        controller.sendPacket(new ConfirmChangeC2SPacket(this.syncId));
    }
}

