/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.network;

import cuchaz.enigma.network.ClientPacketHandler;
import cuchaz.enigma.network.Message;
import cuchaz.enigma.network.ServerPacketHandler;
import cuchaz.enigma.network.packet.KickS2CPacket;
import cuchaz.enigma.network.packet.MessageS2CPacket;
import cuchaz.enigma.network.packet.Packet;
import cuchaz.enigma.network.packet.PacketRegistry;
import cuchaz.enigma.network.packet.RemoveMappingS2CPacket;
import cuchaz.enigma.network.packet.RenameS2CPacket;
import cuchaz.enigma.network.packet.UserListS2CPacket;
import cuchaz.enigma.translation.mapping.EntryMapping;
import cuchaz.enigma.translation.mapping.EntryRemapper;
import cuchaz.enigma.translation.representation.entry.Entry;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;

public abstract class EnigmaServer {
    public static final int DEFAULT_PORT = 34712;
    public static final int PROTOCOL_VERSION = 0;
    public static final String OWNER_USERNAME = "Owner";
    public static final int CHECKSUM_SIZE = 20;
    public static final int MAX_PASSWORD_LENGTH = 255;
    private final int port;
    private ServerSocket socket;
    private List<Socket> clients = new CopyOnWriteArrayList<Socket>();
    private Map<Socket, String> usernames = new HashMap<Socket, String>();
    private Set<Socket> unapprovedClients = new HashSet<Socket>();
    private final byte[] jarChecksum;
    private final char[] password;
    public static final int DUMMY_SYNC_ID = 0;
    private final EntryRemapper mappings;
    private Map<Entry<?>, Integer> syncIds = new HashMap();
    private Map<Integer, Entry<?>> inverseSyncIds = new HashMap();
    private Map<Integer, Set<Socket>> clientsNeedingConfirmation = new HashMap<Integer, Set<Socket>>();
    private int nextSyncId = 1;
    private static int nextIoId = 0;

    public EnigmaServer(byte[] jarChecksum, char[] password, EntryRemapper mappings, int port) {
        this.jarChecksum = jarChecksum;
        this.password = password;
        this.mappings = mappings;
        this.port = port;
    }

    public void start() throws IOException {
        this.socket = new ServerSocket(this.port);
        this.log("Server started on " + this.socket.getInetAddress() + ":" + this.port);
        Thread thread = new Thread(() -> {
            try {
                while (!this.socket.isClosed()) {
                    this.acceptClient();
                }
            }
            catch (SocketException e) {
                System.out.println("Server closed");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
        thread.setName("Server client listener");
        thread.setDaemon(true);
        thread.start();
    }

    private void acceptClient() throws IOException {
        Socket client = this.socket.accept();
        this.clients.add(client);
        Thread thread = new Thread(() -> {
            try {
                DataInputStream input = new DataInputStream(client.getInputStream());
                while (true) {
                    int packetId;
                    try {
                        packetId = input.readUnsignedByte();
                    }
                    catch (EOFException | SocketException e) {
                        break;
                    }
                    Packet<ServerPacketHandler> packet = PacketRegistry.createC2SPacket(packetId);
                    if (packet == null) {
                        throw new IOException("Received invalid packet id " + packetId);
                    }
                    packet.read(input);
                    this.runOnThread(() -> packet.handle(new ServerPacketHandler(client, this)));
                }
            }
            catch (IOException e) {
                this.kick(client, e.toString());
                e.printStackTrace();
                return;
            }
            this.kick(client, "disconnect.disconnected");
        });
        thread.setName("Server I/O thread #" + nextIoId++);
        thread.setDaemon(true);
        thread.start();
    }

    public void stop() {
        this.runOnThread(() -> {
            if (this.socket != null && !this.socket.isClosed()) {
                for (Socket client : this.clients) {
                    this.kick(client, "disconnect.server_closed");
                }
                try {
                    this.socket.close();
                }
                catch (IOException e) {
                    System.err.println("Failed to close server socket");
                    e.printStackTrace();
                }
            }
        });
    }

    public void kick(Socket client, String reason) {
        if (!this.clients.remove(client)) {
            return;
        }
        this.sendPacket(client, new KickS2CPacket(reason));
        this.clientsNeedingConfirmation.values().removeIf(list -> {
            list.remove(client);
            return list.isEmpty();
        });
        String username = this.usernames.remove(client);
        try {
            client.close();
        }
        catch (IOException e) {
            System.err.println("Failed to close server client socket");
            e.printStackTrace();
        }
        if (username != null) {
            System.out.println("Kicked " + username + " because " + reason);
            this.sendMessage(Message.disconnect(username));
        }
        this.sendUsernamePacket();
    }

    public boolean isUsernameTaken(String username) {
        return this.usernames.containsValue(username);
    }

    public void setUsername(Socket client, String username) {
        this.usernames.put(client, username);
        this.sendUsernamePacket();
    }

    private void sendUsernamePacket() {
        ArrayList<String> usernames = new ArrayList<String>(this.usernames.values());
        Collections.sort(usernames);
        this.sendToAll(new UserListS2CPacket(usernames));
    }

    public String getUsername(Socket client) {
        return this.usernames.get(client);
    }

    public void sendPacket(Socket client, Packet<ClientPacketHandler> packet) {
        block3: {
            if (!client.isClosed()) {
                int packetId = PacketRegistry.getS2CId(packet);
                try {
                    DataOutputStream output = new DataOutputStream(client.getOutputStream());
                    output.writeByte(packetId);
                    packet.write(output);
                }
                catch (IOException e) {
                    if (packet instanceof KickS2CPacket) break block3;
                    this.kick(client, e.toString());
                    e.printStackTrace();
                }
            }
        }
    }

    public void sendToAll(Packet<ClientPacketHandler> packet) {
        for (Socket client : this.clients) {
            this.sendPacket(client, packet);
        }
    }

    public void sendToAllExcept(Socket excluded, Packet<ClientPacketHandler> packet) {
        for (Socket client : this.clients) {
            if (client == excluded) continue;
            this.sendPacket(client, packet);
        }
    }

    public boolean canModifyEntry(Socket client, Entry<?> entry) {
        if (this.unapprovedClients.contains(client)) {
            return false;
        }
        Integer syncId = this.syncIds.get(entry);
        if (syncId == null) {
            return true;
        }
        Set<Socket> clients = this.clientsNeedingConfirmation.get(syncId);
        return clients == null || !clients.contains(client);
    }

    public int lockEntry(Socket exception, Entry<?> entry) {
        Integer oldSyncId;
        int syncId = this.nextSyncId++;
        if (this.nextSyncId == 65536) {
            this.nextSyncId = 1;
        }
        if ((oldSyncId = this.syncIds.get(entry)) != null) {
            this.clientsNeedingConfirmation.remove(oldSyncId);
        }
        this.syncIds.put(entry, syncId);
        this.inverseSyncIds.put(syncId, entry);
        HashSet<Socket> clients = new HashSet<Socket>(this.clients);
        clients.remove(exception);
        this.clientsNeedingConfirmation.put(syncId, clients);
        return syncId;
    }

    public void confirmChange(Socket client, int syncId) {
        Set<Socket> clients;
        if (this.usernames.containsKey(client)) {
            this.unapprovedClients.remove(client);
        }
        if ((clients = this.clientsNeedingConfirmation.get(syncId)) != null) {
            clients.remove(client);
            if (clients.isEmpty()) {
                this.clientsNeedingConfirmation.remove(syncId);
                this.syncIds.remove(this.inverseSyncIds.remove(syncId));
            }
        }
    }

    public void sendCorrectMapping(Socket client, Entry<?> entry, boolean refreshClassTree) {
        String oldName;
        EntryMapping oldMapping = this.mappings.getDeobfMapping(entry);
        String string = oldName = oldMapping == null ? null : oldMapping.getTargetName();
        if (oldName == null) {
            this.sendPacket(client, new RemoveMappingS2CPacket(0, entry));
        } else {
            this.sendPacket(client, new RenameS2CPacket(0, entry, oldName, refreshClassTree));
        }
    }

    protected abstract void runOnThread(Runnable var1);

    public void log(String message) {
        System.out.println(message);
    }

    protected boolean isRunning() {
        return !this.socket.isClosed();
    }

    public byte[] getJarChecksum() {
        return this.jarChecksum;
    }

    public char[] getPassword() {
        return this.password;
    }

    public EntryRemapper getMappings() {
        return this.mappings;
    }

    public void sendMessage(Message message) {
        this.log(String.format("[MSG] %s", message.translate()));
        this.sendToAll(new MessageS2CPacket(message));
    }
}

