/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.gui.stats;

import com.google.gson.GsonBuilder;
import cuchaz.enigma.EnigmaProject;
import cuchaz.enigma.ProgressListener;
import cuchaz.enigma.analysis.index.EntryIndex;
import cuchaz.enigma.api.service.NameProposalService;
import cuchaz.enigma.api.service.ObfuscationTestService;
import cuchaz.enigma.gui.stats.StatsMember;
import cuchaz.enigma.translation.Translatable;
import cuchaz.enigma.translation.mapping.EntryRemapper;
import cuchaz.enigma.translation.mapping.EntryResolver;
import cuchaz.enigma.translation.mapping.ResolutionStrategy;
import cuchaz.enigma.translation.representation.TypeDescriptor;
import cuchaz.enigma.translation.representation.entry.ClassEntry;
import cuchaz.enigma.translation.representation.entry.Entry;
import cuchaz.enigma.translation.representation.entry.FieldEntry;
import cuchaz.enigma.translation.representation.entry.LocalVariableEntry;
import cuchaz.enigma.translation.representation.entry.MethodDefEntry;
import cuchaz.enigma.translation.representation.entry.MethodEntry;
import cuchaz.enigma.utils.I18n;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class StatsGenerator {
    private final EntryIndex entryIndex;
    private final EntryRemapper mapper;
    private final EntryResolver entryResolver;
    private final List<ObfuscationTestService> obfuscationTestServices;
    private final List<NameProposalService> nameProposalServices;

    public StatsGenerator(EnigmaProject project) {
        this.entryIndex = project.getJarIndex().getEntryIndex();
        this.mapper = project.getMapper();
        this.entryResolver = project.getJarIndex().getEntryResolver();
        this.obfuscationTestServices = project.getEnigma().getServices().get(ObfuscationTestService.TYPE);
        this.nameProposalServices = project.getEnigma().getServices().get(NameProposalService.TYPE);
    }

    public String generate(ProgressListener progress, Set<StatsMember> includedMembers) {
        includedMembers = EnumSet.copyOf(includedMembers);
        int totalWork = 0;
        if (includedMembers.contains((Object)StatsMember.METHODS) || includedMembers.contains((Object)StatsMember.PARAMETERS)) {
            totalWork += this.entryIndex.getMethods().size();
        }
        if (includedMembers.contains((Object)StatsMember.FIELDS)) {
            totalWork += this.entryIndex.getFields().size();
        }
        if (includedMembers.contains((Object)StatsMember.CLASSES)) {
            totalWork += this.entryIndex.getClasses().size();
        }
        progress.init(totalWork, "progress.stats");
        HashMap<String, Integer> counts = new HashMap<String, Integer>();
        int numDone = 0;
        if (includedMembers.contains((Object)StatsMember.METHODS) || includedMembers.contains((Object)StatsMember.PARAMETERS)) {
            for (MethodEntry method : this.entryIndex.getMethods()) {
                progress.step(numDone++, I18n.translate("type.methods"));
                MethodEntry root = this.entryResolver.resolveEntry(method, ResolutionStrategy.RESOLVE_ROOT).stream().findFirst().orElseThrow(AssertionError::new);
                if (root != method || ((MethodDefEntry)method).getAccess().isSynthetic()) continue;
                if (includedMembers.contains((Object)StatsMember.METHODS)) {
                    this.update(counts, method);
                }
                if (!includedMembers.contains((Object)StatsMember.PARAMETERS)) continue;
                int index = ((MethodDefEntry)method).getAccess().isStatic() ? 0 : 1;
                for (TypeDescriptor argument : method.getDesc().getArgumentDescs()) {
                    this.update(counts, new LocalVariableEntry(method, index, "", true, null));
                    index += argument.getSize();
                }
            }
        }
        if (includedMembers.contains((Object)StatsMember.FIELDS)) {
            for (FieldEntry field : this.entryIndex.getFields()) {
                progress.step(numDone++, I18n.translate("type.fields"));
                this.update(counts, field);
            }
        }
        if (includedMembers.contains((Object)StatsMember.CLASSES)) {
            for (ClassEntry clazz : this.entryIndex.getClasses()) {
                progress.step(numDone++, I18n.translate("type.classes"));
                this.update(counts, clazz);
            }
        }
        progress.step(-1, I18n.translate("progress.stats.data"));
        Tree tree = new Tree();
        for (Map.Entry entry : counts.entrySet()) {
            if (((String)entry.getKey()).startsWith("com.mojang")) continue;
            tree.getNode((String)((String)entry.getKey())).value = entry.getValue();
        }
        tree.collapse(tree.root);
        return new GsonBuilder().setPrettyPrinting().create().toJson(tree.root);
    }

    private void update(Map<String, Integer> counts, Entry<?> entry) {
        if (this.isObfuscated(entry)) {
            String parent = ((Entry)this.mapper.deobfuscate((Translatable)entry.getAncestry().get(0))).getName().replace('/', '.');
            counts.put(parent, counts.getOrDefault(parent, 0) + 1);
        }
    }

    private boolean isObfuscated(Entry<?> entry) {
        String mappedName;
        String name = entry.getName();
        if (!this.obfuscationTestServices.isEmpty()) {
            for (ObfuscationTestService obfuscationTestService : this.obfuscationTestServices) {
                if (!obfuscationTestService.testDeobfuscated(entry)) continue;
                return false;
            }
        }
        if (!this.nameProposalServices.isEmpty()) {
            for (NameProposalService nameProposalService : this.nameProposalServices) {
                if (!nameProposalService.proposeName(entry, this.mapper).isPresent()) continue;
                return false;
            }
        }
        return (mappedName = this.mapper.deobfuscate(entry).getName()) == null || mappedName.isEmpty() || mappedName.equals(name);
    }

    private static class Tree<T> {
        public final Node<T> root;
        private final Map<String, Node<T>> nodes = new HashMap<String, Node<T>>();

        public Tree() {
            this.root = new Node<Object>("", null);
        }

        public Node<T> getNode(String name) {
            Node<Object> node = this.nodes.get(name);
            if (node == null) {
                node = this.root;
                for (String part : name.split("\\.")) {
                    Node<Object> child = (Node<Object>)((Node)node).namedChildren.get(part);
                    if (child == null) {
                        child = new Node<Object>(part, null);
                        ((Node)node).namedChildren.put(part, child);
                        node.children.add(child);
                    }
                    node = child;
                }
                this.nodes.put(name, node);
            }
            return node;
        }

        public void collapse(Node<T> node) {
            while (node.children.size() == 1) {
                Node child = node.children.get(0);
                node.name = node.name.isEmpty() ? child.name : node.name + "." + child.name;
                node.children = child.children;
                node.value = child.value;
            }
            for (Node child : node.children) {
                this.collapse(child);
            }
        }

        public static class Node<T> {
            public String name;
            public T value;
            public List<Node<T>> children = new ArrayList<Node<T>>();
            private final transient Map<String, Node<T>> namedChildren = new HashMap<String, Node<T>>();

            public Node(String name, T value) {
                this.name = name;
                this.value = value;
            }
        }
    }
}

