/*
 * Decompiled with CFR 0.152.
 */
package com.github.swingdpi.plaf;

import com.github.swingdpi.plaf.ScaledFontUIResource;
import com.github.swingdpi.plaf.ScaledIconUIResource;
import com.github.swingdpi.plaf.Tweaker;
import com.github.swingdpi.util.ScaledIcon;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.util.Arrays;
import java.util.List;
import javax.swing.Icon;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.plaf.DimensionUIResource;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.InsetsUIResource;
import javax.swing.plaf.UIResource;

public class BasicTweaker
implements Tweaker {
    private static final String[] LOWER_SUFFIXES_FOR_SCALED_INTEGERS = new String[]{"width", "height", "indent", "size", "gap"};
    private static final List<String> INSET_SCALING_BLACKLIST = Arrays.asList("Spinner.arrowButtonInsets");
    protected final float scaleFactor;
    protected final UIDefaults uiDefaults = UIManager.getLookAndFeelDefaults();
    protected boolean doExtraTweaks = true;

    public BasicTweaker(float scaleFactor) {
        this.scaleFactor = scaleFactor;
    }

    @Override
    public void initialTweaks() {
        if (this.doExtraTweaks) {
            this.uiDefaults.put("Tree.rowHeight", (Object)19);
        }
    }

    public void setDoExtraTweaks(boolean flag) {
        this.doExtraTweaks = flag;
    }

    @Override
    public Font modifyFont(Object key, Font original) {
        if (BasicTweaker.isUnscaled(this.scaleFactor)) {
            return original;
        }
        if (original instanceof UIResource) {
            return BasicTweaker.newScaledFontUIResource(original, this.scaleFactor);
        }
        return original;
    }

    protected static FontUIResource newScaledFontUIResource(Font original, float scale) {
        float newSize = Math.round((float)original.getSize() * scale);
        return new ScaledFontUIResource(original.deriveFont(newSize));
    }

    @Override
    public Icon modifyIcon(Object key, Icon original) {
        float scale = this.scaleFactor;
        return BasicTweaker.newScaledIconUIResource(original, scale);
    }

    protected static Icon newScaledIconUIResource(Icon original, float scale) {
        if (BasicTweaker.isUnscaled(scale) && original instanceof UIResource) {
            return original;
        }
        return new ScaledIconUIResource(new ScaledIcon(original, scale));
    }

    @Override
    public Dimension modifyDimension(Object key, Dimension original) {
        if (BasicTweaker.isUnscaled(this.scaleFactor)) {
            return original;
        }
        int width = Math.round((float)original.width * this.scaleFactor);
        if ("Spinner.arrowButtonSize".equals(key)) {
            return new Dimension(width, original.height);
        }
        if (!(original instanceof UIResource)) {
            return original;
        }
        int height = Math.round((float)original.height * this.scaleFactor);
        return new DimensionUIResource(width, height);
    }

    @Override
    public Integer modifyInteger(Object key, Integer original) {
        return BasicTweaker.scaleIntegerIfMetric(key, original, this.scaleFactor);
    }

    protected static Integer scaleIntegerIfMetric(Object key, Integer original, float scale) {
        if (BasicTweaker.isUnscaled(scale) || !BasicTweaker.endsWithOneOf(BasicTweaker.lower(key), BasicTweaker.getLowerSuffixesForScaledIntegers())) {
            return original;
        }
        return Math.round((float)original.intValue() * scale);
    }

    @Override
    public Insets modifyInsets(Object key, Insets original) {
        if (BasicTweaker.isUnscaled(this.scaleFactor) || !(original instanceof UIResource) || INSET_SCALING_BLACKLIST.contains(key)) {
            return original;
        }
        Insets insets = original;
        return new InsetsUIResource(Math.round(this.scaleFactor * (float)insets.top), Math.round(this.scaleFactor * (float)insets.left), Math.round(this.scaleFactor * (float)insets.bottom), Math.round(this.scaleFactor * (float)insets.right));
    }

    private static boolean endsWithOneOf(String text, String[] suffixes) {
        for (String suffix : suffixes) {
            if (!text.endsWith(suffix)) continue;
            return true;
        }
        return false;
    }

    private static String lower(Object key) {
        return key instanceof String ? ((String)key).toLowerCase() : "";
    }

    protected static String[] getLowerSuffixesForScaledIntegers() {
        return LOWER_SUFFIXES_FOR_SCALED_INTEGERS;
    }

    protected static boolean isUnscaled(float scale) {
        return Math.abs(scale - 1.0f) < 0.001f;
    }

    @Override
    public void finalTweaks() {
        if (this.doExtraTweaks) {
            this.uiDefaults.put("Tree.paintLines", (Object)false);
            this.fadeColor("Table.gridColor", "Table.background");
        }
    }

    private void fadeColor(String toFade, String background) {
        Color main = this.uiDefaults.getColor(toFade);
        Color bg = this.uiDefaults.getColor(background);
        if (main != null && bg != null) {
            this.uiDefaults.put(toFade, BasicTweaker.blendColour(main, bg, 25));
        }
    }

    private static Color blendColour(Color a, Color b, int percentA) {
        int percentB = 100 - percentA;
        return new Color((a.getRed() * percentA + b.getRed() * percentB) / 100, (a.getGreen() * percentA + b.getGreen() * percentB) / 100, (a.getBlue() * percentA + b.getBlue() * percentB) / 100);
    }
}

