/*
 * Decompiled with CFR 0.152.
 */
package com.bulenkov.iconloader;

import com.bulenkov.iconloader.AppleHiDPIScaledImage;
import com.bulenkov.iconloader.IconLoader;
import com.bulenkov.iconloader.JBHiDPIScaledImage;
import com.bulenkov.iconloader.util.SystemInfo;
import com.bulenkov.iconloader.util.UIUtil;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;

public class RetinaImage {
    public static Image createFrom(Image image) {
        return RetinaImage.createFrom(image, 2, IconLoader.ourComponent);
    }

    public static Image createFrom(Image image, int scale, ImageObserver observer) {
        int w = image.getWidth(observer);
        int h2 = image.getHeight(observer);
        BufferedImage hidpi = RetinaImage.create(image, w / scale, h2 / scale, 2);
        if (SystemInfo.isAppleJvm) {
            Graphics2D g2 = (Graphics2D)((Image)hidpi).getGraphics();
            g2.scale(1.0f / (float)scale, 1.0f / (float)scale);
            g2.drawImage(image, 0, 0, null);
            g2.dispose();
        }
        return hidpi;
    }

    public static BufferedImage create(int width, int height, int type) {
        return RetinaImage.create(null, width, height, type);
    }

    private static BufferedImage create(Image image, int width, int height, int type) {
        if (SystemInfo.isAppleJvm) {
            return AppleHiDPIScaledImage.create(width, height, type);
        }
        if (image == null) {
            return new JBHiDPIScaledImage(width, height, type);
        }
        return new JBHiDPIScaledImage(image, width, height, type);
    }

    public static boolean isAppleHiDPIScaledImage(Image image) {
        return UIUtil.isAppleRetina() && AppleHiDPIScaledImage.is(image);
    }
}

