/*
 * Decompiled with CFR 0.152.
 */
package com.bulenkov.darcula.ui;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicTabbedPaneUI;

public class DarculaTabbedPaneUI
extends BasicTabbedPaneUI {
    public static ComponentUI createUI(JComponent c) {
        return new DarculaTabbedPaneUI();
    }

    @Override
    protected void paintTabBorder(Graphics g2, int tabPlacement, int tabIndex, int x, int y, int w, int h2, boolean isSelected) {
        g2.setColor(this.lightHighlight);
        switch (tabPlacement) {
            case 2: 
            case 4: {
                super.paintTabBorder(g2, tabPlacement, tabIndex, x, y, w, h2, isSelected);
                break;
            }
            case 3: {
                if (tabIndex == 0) {
                    g2.drawLine(x, y, x, y + h2 - 1);
                }
                g2.drawLine(x, y + h2 - 1, x + w - 1, y + h2 - 1);
                g2.drawLine(x + w - 1, y + h2 - 1, x + w - 1, y);
                break;
            }
            default: {
                if (tabIndex == 0) {
                    g2.drawLine(x, y, x, y + h2 - 1);
                }
                g2.drawLine(x, y, x + w - 1, y);
                g2.drawLine(x + w - 1, y, x + w - 1, y + h2 - 1);
            }
        }
    }

    @Override
    protected void paintTabBackground(Graphics g2, int tabPlacement, int tabIndex, int x, int y, int w, int h2, boolean isSelected) {
        Color selectedColor = UIManager.getColor("TabbedPane.selected");
        g2.setColor(!isSelected || selectedColor == null ? this.tabPane.getBackgroundAt(tabIndex) : selectedColor);
        switch (tabPlacement) {
            case 2: 
            case 4: {
                super.paintTabBackground(g2, tabPlacement, tabIndex, x, y, w, h2, isSelected);
                break;
            }
            case 3: {
                g2.fillRect(x, y, w - 1, h2 - 1);
                break;
            }
            default: {
                g2.fillRect(x, y + 1, w - 1, h2 - 1);
            }
        }
    }

    @Override
    protected void paintContentBorderTopEdge(Graphics g2, int tabPlacement, int selectedIndex, int x, int y, int w, int h2) {
        Rectangle selRect = selectedIndex < 0 ? null : this.getTabBounds(selectedIndex, this.calcRect);
        g2.setColor(this.lightHighlight);
        if (tabPlacement != 1 || selectedIndex < 0 || selRect.y + selRect.height + 1 < y || selRect.x < x || selRect.x > x + w) {
            g2.drawLine(x, y, x + w - 2, y);
        } else {
            g2.drawLine(x, y, selRect.x - 1, y);
            if (selRect.x + selRect.width < x + w - 1) {
                g2.drawLine(selRect.x + selRect.width - 1, y, x + w - 1, y);
            } else {
                g2.setColor(this.shadow);
                g2.drawLine(x + w - 2, y, x + w - 2, y);
            }
        }
    }

    @Override
    protected void paintContentBorderBottomEdge(Graphics g2, int tabPlacement, int selectedIndex, int x, int y, int w, int h2) {
        Rectangle selRect = selectedIndex < 0 ? null : this.getTabBounds(selectedIndex, this.calcRect);
        g2.setColor(this.lightHighlight);
        if (tabPlacement != 3 || selectedIndex < 0 || selRect.y - 1 > h2 || selRect.x < x || selRect.x > x + w) {
            g2.drawLine(x + 1, y + h2 - 1, x + w - 2, y + h2 - 1);
        } else {
            g2.drawLine(x, y + h2 - 1, selRect.x - 1, y + h2 - 1);
            if (selRect.x + selRect.width < x + w - 1) {
                g2.drawLine(selRect.x + selRect.width - 1, y + h2 - 1, x + w - 1, y + h2 - 1);
            }
        }
    }

    @Override
    protected Insets getContentBorderInsets(int tabPlacement) {
        Insets insets = this.contentBorderInsets;
        if (tabPlacement == 3) {
            insets = new Insets(insets.bottom, insets.left, insets.top, insets.right);
        }
        return insets;
    }
}

