/*
 * Decompiled with CFR 0.152.
 */
package com.bulenkov.darcula.ui;

import com.bulenkov.darcula.DarculaUIUtil;
import com.bulenkov.darcula.ui.DarculaButtonUI;
import com.bulenkov.iconloader.util.GraphicsConfig;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import javax.swing.JButton;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.InsetsUIResource;
import javax.swing.plaf.UIResource;

public class DarculaButtonPainter
implements Border,
UIResource {
    private static final int myOffset = 4;

    @Override
    public void paintBorder(Component c, Graphics g2, int x, int y, int width, int height) {
        int offset;
        Graphics2D g2d = (Graphics2D)g2;
        Insets ins = this.getBorderInsets(c);
        int yOff = (ins.top + ins.bottom) / 4;
        boolean square = DarculaButtonUI.isSquare(c);
        int n = offset = square ? 1 : this.getOffset();
        if (c.hasFocus()) {
            DarculaUIUtil.paintFocusRing(g2d, offset, yOff, width - 2 * offset, height - 2 * yOff);
        } else {
            Color borderColor = c instanceof JButton && ((JButton)c).isDefaultButton() ? UIManager.getColor("Button.darcula.borderColor.defaultButton") : UIManager.getColor("Button.darcula.borderColor");
            GraphicsConfig config = new GraphicsConfig(g2);
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2d.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_DEFAULT);
            g2d.setColor(borderColor);
            g2.drawRoundRect(x + offset, y + yOff, width - 2 * offset, height - 2 * yOff, square ? 3 : 5, square ? 3 : 5);
            config.restore();
        }
    }

    @Override
    public Insets getBorderInsets(Component c) {
        if (DarculaButtonUI.isSquare(c)) {
            return new InsetsUIResource(2, 0, 2, 0);
        }
        return new InsetsUIResource(8, 16, 8, 14);
    }

    protected int getOffset() {
        return 4;
    }

    @Override
    public boolean isBorderOpaque() {
        return false;
    }
}

