/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.network.packet;

import cuchaz.enigma.network.Message;
import cuchaz.enigma.network.ServerPacketHandler;
import cuchaz.enigma.network.packet.ChangeDocsS2CPacket;
import cuchaz.enigma.network.packet.Packet;
import cuchaz.enigma.network.packet.PacketHelper;
import cuchaz.enigma.translation.mapping.EntryMapping;
import cuchaz.enigma.translation.representation.entry.Entry;
import cuchaz.enigma.utils.Utils;
import cuchaz.enigma.utils.validation.PrintValidatable;
import cuchaz.enigma.utils.validation.Validatable;
import cuchaz.enigma.utils.validation.ValidationContext;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class ChangeDocsC2SPacket
implements Packet<ServerPacketHandler> {
    private Entry<?> entry;
    private String newDocs;

    ChangeDocsC2SPacket() {
    }

    public ChangeDocsC2SPacket(Entry<?> entry, String newDocs) {
        this.entry = entry;
        this.newDocs = newDocs;
    }

    @Override
    public void read(DataInput input) throws IOException {
        this.entry = PacketHelper.readEntry(input);
        this.newDocs = PacketHelper.readString(input);
    }

    @Override
    public void write(DataOutput output) throws IOException {
        PacketHelper.writeEntry(output, this.entry);
        PacketHelper.writeString(output, this.newDocs);
    }

    @Override
    public void handle(ServerPacketHandler handler) {
        ValidationContext vc = new ValidationContext();
        vc.setActiveElement((Validatable)PrintValidatable.INSTANCE);
        EntryMapping mapping = handler.getServer().getMappings().getDeobfMapping(this.entry);
        boolean valid = handler.getServer().canModifyEntry(handler.getClient(), this.entry);
        if (!valid) {
            String oldDocs = mapping == null ? null : mapping.getJavadoc();
            handler.getServer().sendPacket(handler.getClient(), new ChangeDocsS2CPacket(0, this.entry, oldDocs == null ? "" : oldDocs));
            return;
        }
        if (mapping == null) {
            mapping = new EntryMapping(((Entry)handler.getServer().getMappings().deobfuscate(this.entry)).getName());
        }
        handler.getServer().getMappings().mapFromObf(vc, this.entry, mapping.withDocs(Utils.isBlank((String)this.newDocs) ? null : this.newDocs));
        if (!vc.canProceed()) {
            return;
        }
        int syncId = handler.getServer().lockEntry(handler.getClient(), this.entry);
        handler.getServer().sendToAllExcept(handler.getClient(), new ChangeDocsS2CPacket(syncId, this.entry, this.newDocs));
        handler.getServer().sendMessage(Message.editDocs(handler.getServer().getUsername(handler.getClient()), this.entry));
    }
}

