/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.util;

import java.io.IOException;
import java.lang.module.ModuleDescriptor;
import java.util.ArrayList;
import java.util.stream.Stream;
import org.jetbrains.java.decompiler.main.DecompilerContext;
import org.jetbrains.java.decompiler.main.extern.IContextSource;
import org.jetbrains.java.decompiler.main.extern.IFernflowerLogger;

abstract class ModuleBasedContextSource
implements IContextSource {
    private final ModuleDescriptor ref;

    public ModuleBasedContextSource(ModuleDescriptor ref) {
        this.ref = ref;
    }

    @Override
    public String getName() {
        return "module " + this.ref.toNameAndVersion();
    }

    protected abstract Stream<String> entryNames() throws IOException;

    @Override
    public IContextSource.Entries getEntries() {
        ArrayList<IContextSource.Entry> classNames = new ArrayList<IContextSource.Entry>();
        ArrayList<String> directoryNames = new ArrayList<String>();
        ArrayList<IContextSource.Entry> otherEntries = new ArrayList<IContextSource.Entry>();
        try {
            this.entryNames().forEach(name -> {
                if (name.endsWith("/")) {
                    directoryNames.add(name.substring(0, name.length() - 1));
                } else if (name.endsWith(".class")) {
                    classNames.add(IContextSource.Entry.atBase(name.substring(0, name.length() - ".class".length())));
                } else {
                    otherEntries.add(IContextSource.Entry.atBase(name));
                }
            });
        }
        catch (IOException ex) {
            DecompilerContext.getLogger().writeMessage("Failed to list contents of " + this.getName(), IFernflowerLogger.Severity.ERROR, ex);
        }
        return new IContextSource.Entries(classNames, directoryNames, otherEntries);
    }
}

