/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.modules.decompiler;

import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.java.decompiler.modules.decompiler.ValidationHelper;
import org.jetbrains.java.decompiler.modules.decompiler.stats.Statement;

public class StatEdge {
    public static final int TYPE_REGULAR = 1;
    public static final int TYPE_EXCEPTION = 2;
    public static final int TYPE_BREAK = 4;
    public static final int TYPE_CONTINUE = 8;
    public static final int TYPE_FINALLYEXIT = 32;
    public static final int[] TYPES = new int[]{1, 2, 4, 8, 32};
    private int type;
    private Statement source;
    private Statement destination;
    private List<String> exceptions;
    @Nullable
    public Statement closure;
    public boolean labeled = true;
    public boolean explicit = true;
    public boolean canInline = true;
    public boolean phantomContinue = false;

    public StatEdge(int type, Statement source, Statement destination, @Nullable Statement closure) {
        this(type, source, destination);
        this.closure = closure;
    }

    public StatEdge(int type, Statement source, Statement destination) {
        this.type = type;
        this.source = source;
        this.destination = destination;
        ValidationHelper.notNull(source);
        ValidationHelper.notNull(destination);
    }

    public StatEdge(Statement source, Statement destination, List<String> exceptions) {
        this(2, source, destination);
        if (exceptions != null) {
            this.exceptions = new ArrayList<String>(exceptions);
        }
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public Statement getSource() {
        return this.source;
    }

    public void setSource(Statement source) {
        ValidationHelper.assertTrue(source != null, "Should not be null");
        this.source = source;
    }

    public void changeSource(Statement newSource) {
        ValidationHelper.assertTrue(newSource != null, "Should not be null");
        Statement oldSource = this.source;
        oldSource.removeEdgeInternal(Statement.EdgeDirection.FORWARD, this);
        newSource.addEdgeInternal(Statement.EdgeDirection.FORWARD, this);
        this.source = newSource;
    }

    public Statement getDestination() {
        return this.destination;
    }

    public void setDestination(Statement destination) {
        ValidationHelper.assertTrue(destination != null, "Should not be null");
        this.destination = destination;
    }

    public void changeDestination(Statement newDestination) {
        ValidationHelper.assertTrue(newDestination != null, "Should not be null");
        Statement oldDestination = this.destination;
        oldDestination.removeEdgeInternal(Statement.EdgeDirection.BACKWARD, this);
        newDestination.addEdgeInternal(Statement.EdgeDirection.BACKWARD, this);
        this.destination = newDestination;
    }

    public void changeType(int type) {
        this.source.changeEdgeType(Statement.EdgeDirection.FORWARD, this, type);
    }

    public void remove() {
        this.source.removeEdgeInternal(Statement.EdgeDirection.FORWARD, this);
        this.destination.removeEdgeInternal(Statement.EdgeDirection.BACKWARD, this);
        if (this.closure != null) {
            this.closure.getLabelEdges().remove(this);
        }
    }

    public void removeClosure() {
        ValidationHelper.validateTrue(this.closure != null, "closure shouldn't be null here");
        this.closure.getLabelEdges().remove(this);
        this.labeled = false;
        this.closure = null;
    }

    public List<String> getExceptions() {
        return this.exceptions;
    }

    public String toString() {
        return this.type + ": " + this.source.toString() + " -> " + this.destination.toString() + (String)(this.closure == null ? "" : " (" + this.closure + ")") + (String)(this.exceptions == null ? "" : " Exceptions: " + this.exceptions);
    }

    public void changeClosure(Statement stat) {
        if (this.closure != null) {
            this.closure.getLabelEdges().remove(this);
        }
        this.closure = stat;
        if (this.closure != null) {
            this.closure.getLabelEdges().add(this);
        }
    }
}

