/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.bytecode.translators;

import cuchaz.enigma.translation.LocalNameGenerator;
import cuchaz.enigma.translation.representation.TypeDescriptor;
import cuchaz.enigma.translation.representation.entry.ClassDefEntry;
import cuchaz.enigma.translation.representation.entry.MethodDefEntry;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;

public class LocalVariableFixVisitor
extends ClassVisitor {
    private ClassDefEntry ownerEntry;

    public LocalVariableFixVisitor(int api, ClassVisitor visitor) {
        super(api, visitor);
    }

    @Override
    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this.ownerEntry = ClassDefEntry.parse(access, name, signature, superName, interfaces);
        super.visit(version, access, name, signature, superName, interfaces);
    }

    @Override
    public MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
        MethodDefEntry methodEntry = MethodDefEntry.parse(this.ownerEntry, access, name, descriptor, signature);
        return new Method(this.api, methodEntry, super.visitMethod(access, name, descriptor, signature, exceptions));
    }

    private class Method
    extends MethodVisitor {
        private final MethodDefEntry methodEntry;
        private final Map<Integer, String> parameterNames;
        private final Map<Integer, Integer> parameterIndices;
        private boolean hasParameterTable;
        private int parameterIndex;

        Method(int api, MethodDefEntry methodEntry, MethodVisitor visitor) {
            super(api, visitor);
            this.parameterNames = new HashMap<Integer, String>();
            this.parameterIndices = new HashMap<Integer, Integer>();
            this.parameterIndex = 0;
            this.methodEntry = methodEntry;
            int lvIndex = methodEntry.getAccess().isStatic() ? 0 : 1;
            List<TypeDescriptor> parameters = methodEntry.getDesc().getArgumentDescs();
            for (int parameterIndex = 0; parameterIndex < parameters.size(); ++parameterIndex) {
                TypeDescriptor param = parameters.get(parameterIndex);
                this.parameterIndices.put(lvIndex, parameterIndex);
                lvIndex += param.getSize();
            }
        }

        @Override
        public void visitParameter(String name, int access) {
            this.hasParameterTable = true;
            super.visitParameter(this.fixParameterName(this.parameterIndex, name), this.fixParameterAccess(this.parameterIndex, access));
            ++this.parameterIndex;
        }

        @Override
        public void visitLocalVariable(String name, String desc, String signature, Label start, Label end, int index) {
            if (index == 0 && !this.methodEntry.getAccess().isStatic()) {
                name = "this";
            } else if (this.parameterIndices.containsKey(index)) {
                name = this.fixParameterName(this.parameterIndices.get(index), name);
            } else if (this.isInvalidName(name)) {
                name = LocalNameGenerator.generateLocalVariableName(index, new TypeDescriptor(desc));
            }
            super.visitLocalVariable(name, desc, signature, start, end, index);
        }

        private boolean isInvalidName(String name) {
            return name == null || name.isEmpty() || name.chars().anyMatch(ch -> ch < 33 || ch > 126);
        }

        @Override
        public void visitEnd() {
            if (!this.hasParameterTable) {
                List<TypeDescriptor> arguments = this.methodEntry.getDesc().getArgumentDescs();
                for (int argumentIndex = 0; argumentIndex < arguments.size(); ++argumentIndex) {
                    super.visitParameter(this.fixParameterName(argumentIndex, null), this.fixParameterAccess(argumentIndex, 0));
                }
            }
            super.visitEnd();
        }

        private String fixParameterName(int index, String name) {
            if (this.parameterNames.get(index) != null) {
                return this.parameterNames.get(index);
            }
            if (this.isInvalidName(name)) {
                List<TypeDescriptor> arguments = this.methodEntry.getDesc().getArgumentDescs();
                name = LocalNameGenerator.generateArgumentName(index, arguments.get(index), arguments);
            }
            if (index == 0 && LocalVariableFixVisitor.this.ownerEntry.getAccess().isEnum() && this.methodEntry.getName().equals("<init>")) {
                name = "name";
            }
            if (index == 1 && LocalVariableFixVisitor.this.ownerEntry.getAccess().isEnum() && this.methodEntry.getName().equals("<init>")) {
                name = "ordinal";
            }
            this.parameterNames.put(index, name);
            return name;
        }

        private int fixParameterAccess(int index, int access) {
            if (index == 0 && LocalVariableFixVisitor.this.ownerEntry.getAccess().isEnum() && this.methodEntry.getName().equals("<init>")) {
                access |= 0x1000;
            }
            if (index == 1 && LocalVariableFixVisitor.this.ownerEntry.getAccess().isEnum() && this.methodEntry.getName().equals("<init>")) {
                access |= 0x1000;
            }
            return access;
        }
    }
}

