/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.utils.validation;

import cuchaz.enigma.utils.validation.Message;
import cuchaz.enigma.utils.validation.ValidationContext;

public class StandardValidation {
    public static boolean notBlank(ValidationContext vc, String value) {
        if (value.trim().isEmpty()) {
            vc.raise(Message.EMPTY_FIELD, new Object[0]);
            return false;
        }
        return true;
    }

    public static boolean isInt(ValidationContext vc, String value) {
        if (!StandardValidation.notBlank(vc, value)) {
            return false;
        }
        try {
            Integer.parseInt(value);
            return true;
        }
        catch (NumberFormatException e) {
            vc.raise(Message.NOT_INT, new Object[0]);
            return false;
        }
    }

    public static boolean isIntInRange(ValidationContext vc, String value, int min2, int max) {
        if (!StandardValidation.isInt(vc, value)) {
            return false;
        }
        int intVal = Integer.parseInt(value);
        if (intVal < min2 || intVal > max) {
            vc.raise(Message.FIELD_OUT_OF_RANGE_INT, min2, max);
            return false;
        }
        return true;
    }
}

