/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma;

import com.google.common.base.Functions;
import com.google.common.base.Preconditions;
import cuchaz.enigma.Enigma;
import cuchaz.enigma.ProgressListener;
import cuchaz.enigma.analysis.EntryReference;
import cuchaz.enigma.analysis.index.JarIndex;
import cuchaz.enigma.api.service.NameProposalService;
import cuchaz.enigma.bytecode.translators.TranslationClassVisitor;
import cuchaz.enigma.classprovider.ClassProvider;
import cuchaz.enigma.classprovider.ObfuscationFixClassProvider;
import cuchaz.enigma.source.Decompiler;
import cuchaz.enigma.source.DecompilerService;
import cuchaz.enigma.source.SourceSettings;
import cuchaz.enigma.translation.ProposingTranslator;
import cuchaz.enigma.translation.Translator;
import cuchaz.enigma.translation.mapping.EntryMapping;
import cuchaz.enigma.translation.mapping.EntryRemapper;
import cuchaz.enigma.translation.mapping.MappingsChecker;
import cuchaz.enigma.translation.mapping.tree.DeltaTrackingTree;
import cuchaz.enigma.translation.mapping.tree.EntryTree;
import cuchaz.enigma.translation.representation.entry.ClassEntry;
import cuchaz.enigma.translation.representation.entry.Entry;
import cuchaz.enigma.translation.representation.entry.LocalVariableEntry;
import cuchaz.enigma.translation.representation.entry.MethodEntry;
import cuchaz.enigma.utils.I18n;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.ClassNode;

public class EnigmaProject {
    private final Enigma enigma;
    private final Path jarPath;
    private final ClassProvider classProvider;
    private final JarIndex jarIndex;
    private final byte[] jarChecksum;
    private EntryRemapper mapper;

    public EnigmaProject(Enigma enigma, Path jarPath, ClassProvider classProvider, JarIndex jarIndex, byte[] jarChecksum) {
        Preconditions.checkArgument(jarChecksum.length == 20);
        this.enigma = enigma;
        this.jarPath = jarPath;
        this.classProvider = classProvider;
        this.jarIndex = jarIndex;
        this.jarChecksum = jarChecksum;
        this.mapper = EntryRemapper.empty(jarIndex);
    }

    public void setMappings(EntryTree<EntryMapping> mappings) {
        this.mapper = mappings != null ? EntryRemapper.mapped(this.jarIndex, mappings) : EntryRemapper.empty(this.jarIndex);
    }

    public Enigma getEnigma() {
        return this.enigma;
    }

    public Path getJarPath() {
        return this.jarPath;
    }

    public ClassProvider getClassProvider() {
        return this.classProvider;
    }

    public JarIndex getJarIndex() {
        return this.jarIndex;
    }

    public byte[] getJarChecksum() {
        return this.jarChecksum;
    }

    public EntryRemapper getMapper() {
        return this.mapper;
    }

    public void dropMappings(ProgressListener progress) {
        DeltaTrackingTree<EntryMapping> mappings = this.mapper.getObfToDeobf();
        Collection<Entry<?>> dropped = this.dropMappings(mappings, progress);
        for (Entry<?> entry : dropped) {
            mappings.trackChange(entry);
        }
    }

    private Collection<Entry<?>> dropMappings(EntryTree<EntryMapping> mappings, ProgressListener progress) {
        MappingsChecker checker = new MappingsChecker(this.jarIndex, mappings);
        MappingsChecker.Dropped dropped = checker.dropBrokenMappings(progress);
        Map<Entry<?>, String> droppedMappings = dropped.getDroppedMappings();
        for (Map.Entry<Entry<?>, String> mapping : droppedMappings.entrySet()) {
            System.out.println("WARNING: Couldn't find " + mapping.getKey() + " (" + mapping.getValue() + ") in jar. Mapping was dropped.");
        }
        return droppedMappings.keySet();
    }

    public boolean isRenamable(Entry<?> obfEntry) {
        if (obfEntry instanceof MethodEntry) {
            MethodEntry obfMethodEntry = (MethodEntry)obfEntry;
            String name = obfMethodEntry.getName();
            String sig = obfMethodEntry.getDesc().toString();
            if (name.equals("clone") && sig.equals("()Ljava/lang/Object;")) {
                return false;
            }
            if (name.equals("equals") && sig.equals("(Ljava/lang/Object;)Z")) {
                return false;
            }
            if (name.equals("finalize") && sig.equals("()V")) {
                return false;
            }
            if (name.equals("getClass") && sig.equals("()Ljava/lang/Class;")) {
                return false;
            }
            if (name.equals("hashCode") && sig.equals("()I")) {
                return false;
            }
            if (name.equals("notify") && sig.equals("()V")) {
                return false;
            }
            if (name.equals("notifyAll") && sig.equals("()V")) {
                return false;
            }
            if (name.equals("toString") && sig.equals("()Ljava/lang/String;")) {
                return false;
            }
            if (name.equals("wait") && sig.equals("()V")) {
                return false;
            }
            if (name.equals("wait") && sig.equals("(J)V")) {
                return false;
            }
            if (name.equals("wait") && sig.equals("(JI)V")) {
                return false;
            }
        } else if (obfEntry instanceof LocalVariableEntry && !((LocalVariableEntry)obfEntry).isArgument()) {
            return false;
        }
        return this.jarIndex.getEntryIndex().hasEntry(obfEntry);
    }

    public boolean isRenamable(EntryReference<Entry<?>, Entry<?>> obfReference) {
        return obfReference.isNamed() && this.isRenamable(obfReference.getNameableEntry());
    }

    public JarExport exportRemappedJar(ProgressListener progress) {
        Collection<ClassEntry> classEntries = this.jarIndex.getEntryIndex().getClasses();
        ObfuscationFixClassProvider fixingClassProvider = new ObfuscationFixClassProvider(this.classProvider, this.jarIndex);
        NameProposalService[] nameProposalServices = this.getEnigma().getServices().get(NameProposalService.TYPE).toArray(new NameProposalService[0]);
        Translator deobfuscator = nameProposalServices.length == 0 ? this.mapper.getDeobfuscator() : new ProposingTranslator(this.mapper, nameProposalServices);
        AtomicInteger count = new AtomicInteger();
        progress.init(classEntries.size(), I18n.translate("progress.classes.deobfuscating"));
        Map<String, ClassNode> compiled = classEntries.parallelStream().map(entry -> {
            ClassEntry translatedEntry = deobfuscator.translate(entry);
            progress.step(count.getAndIncrement(), translatedEntry.toString());
            ClassNode node = fixingClassProvider.get(entry.getFullName());
            if (node != null) {
                ClassNode translatedNode = new ClassNode();
                node.accept(new TranslationClassVisitor(deobfuscator, 524288, translatedNode));
                return translatedNode;
            }
            return null;
        }).filter(Objects::nonNull).collect(Collectors.toMap(n -> n.name, Functions.identity()));
        return new JarExport(compiled);
    }

    public static enum DecompileErrorStrategy {
        PROPAGATE,
        TRACE_AS_SOURCE,
        IGNORE;

    }

    public static class ClassSource {
        public final String name;
        public final String source;

        ClassSource(String name, String source) {
            this.name = name;
            this.source = source;
        }

        public void writeTo(Path path) throws IOException {
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
            try (BufferedWriter writer = Files.newBufferedWriter(path, new OpenOption[0]);){
                writer.write(this.source);
            }
        }

        public Path resolvePath(Path root) {
            return root.resolve(this.name.replace('.', '/') + ".java");
        }
    }

    public static final class SourceExport {
        public final Collection<ClassSource> decompiled;

        SourceExport(Collection<ClassSource> decompiled) {
            this.decompiled = decompiled;
        }

        public void write(Path path, ProgressListener progress) throws IOException {
            progress.init(this.decompiled.size(), I18n.translate("progress.sources.writing"));
            int count = 0;
            for (ClassSource source : this.decompiled) {
                progress.step(count++, source.name);
                Path sourcePath = source.resolvePath(path);
                source.writeTo(sourcePath);
            }
        }
    }

    public static final class JarExport {
        private final Map<String, ClassNode> compiled;

        JarExport(Map<String, ClassNode> compiled) {
            this.compiled = compiled;
        }

        public void write(Path path, ProgressListener progress) throws IOException {
            progress.init(this.compiled.size(), I18n.translate("progress.jar.writing"));
            try (JarOutputStream out = new JarOutputStream(Files.newOutputStream(path, new OpenOption[0]));){
                AtomicInteger count = new AtomicInteger();
                for (ClassNode node : this.compiled.values()) {
                    progress.step(count.getAndIncrement(), node.name);
                    String entryName = node.name.replace('.', '/') + ".class";
                    ClassWriter writer = new ClassWriter(0);
                    node.accept(writer);
                    out.putNextEntry(new JarEntry(entryName));
                    out.write(writer.toByteArray());
                    out.closeEntry();
                }
            }
        }

        public SourceExport decompile(ProgressListener progress, DecompilerService decompilerService) {
            return this.decompile(progress, decompilerService, DecompileErrorStrategy.PROPAGATE);
        }

        public SourceExport decompile(ProgressListener progress, DecompilerService decompilerService, DecompileErrorStrategy errorStrategy) {
            List<ClassSource> decompiled = this.decompileStream(progress, decompilerService, errorStrategy).collect(Collectors.toList());
            return new SourceExport(decompiled);
        }

        public Stream<ClassSource> decompileStream(ProgressListener progress, DecompilerService decompilerService, DecompileErrorStrategy errorStrategy) {
            Collection classes = this.compiled.values().stream().filter(classNode -> classNode.name.indexOf(36) == -1).collect(Collectors.toList());
            progress.init(classes.size(), I18n.translate("progress.classes.decompiling"));
            Decompiler decompiler = decompilerService.create(this.compiled::get, new SourceSettings(false, false));
            AtomicInteger count = new AtomicInteger();
            return classes.parallelStream().map(translatedNode -> {
                progress.step(count.getAndIncrement(), translatedNode.name);
                String source = null;
                try {
                    source = this.decompileClass((ClassNode)translatedNode, decompiler);
                }
                catch (Throwable throwable) {
                    switch (errorStrategy) {
                        case PROPAGATE: {
                            throw throwable;
                        }
                        case IGNORE: {
                            break;
                        }
                        case TRACE_AS_SOURCE: {
                            StringWriter writer = new StringWriter();
                            throwable.printStackTrace(new PrintWriter(writer));
                            source = writer.toString();
                            break;
                        }
                    }
                }
                if (source == null) {
                    return null;
                }
                return new ClassSource(translatedNode.name, source);
            }).filter(Objects::nonNull);
        }

        private String decompileClass(ClassNode translatedNode, Decompiler decompiler) {
            return decompiler.getSource(translatedNode.name).asString();
        }
    }
}

