/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.translation.representation.entry;

import com.google.common.base.Preconditions;
import cuchaz.enigma.source.RenamableTokenType;
import cuchaz.enigma.translation.TranslateResult;
import cuchaz.enigma.translation.Translator;
import cuchaz.enigma.translation.mapping.EntryMapping;
import cuchaz.enigma.translation.representation.TypeDescriptor;
import cuchaz.enigma.translation.representation.entry.ClassEntry;
import cuchaz.enigma.translation.representation.entry.Entry;
import cuchaz.enigma.translation.representation.entry.ParentedEntry;
import java.util.Objects;
import javax.annotation.Nullable;

public class FieldEntry
extends ParentedEntry<ClassEntry>
implements Comparable<FieldEntry> {
    protected final TypeDescriptor desc;

    public FieldEntry(ClassEntry parent, String name, TypeDescriptor desc) {
        this(parent, name, desc, null);
    }

    public FieldEntry(ClassEntry parent, String name, TypeDescriptor desc, String javadocs) {
        super(parent, name, javadocs);
        Preconditions.checkNotNull(parent, "Owner cannot be null");
        Preconditions.checkNotNull(desc, "Field descriptor cannot be null");
        this.desc = desc;
    }

    public static FieldEntry parse(String owner, String name, String desc) {
        return new FieldEntry(new ClassEntry(owner), name, new TypeDescriptor(desc), null);
    }

    @Override
    public Class<ClassEntry> getParentType() {
        return ClassEntry.class;
    }

    public TypeDescriptor getDesc() {
        return this.desc;
    }

    @Override
    public FieldEntry withName(String name) {
        return new FieldEntry((ClassEntry)this.parent, name, this.desc, null);
    }

    public FieldEntry withParent(ClassEntry parent) {
        return new FieldEntry(parent, this.name, this.desc, null);
    }

    @Override
    protected TranslateResult<FieldEntry> extendedTranslate(Translator translator, @Nullable EntryMapping mapping) {
        String translatedName = mapping != null ? mapping.getTargetName() : this.name;
        String docs = mapping != null ? mapping.getJavadoc() : null;
        return TranslateResult.of(mapping == null ? RenamableTokenType.OBFUSCATED : RenamableTokenType.DEOBFUSCATED, new FieldEntry((ClassEntry)this.parent, translatedName, translator.translate(this.desc), docs));
    }

    public int hashCode() {
        return Objects.hash(this.parent, this.name, this.desc);
    }

    public boolean equals(Object other) {
        return other instanceof FieldEntry && this.equals((FieldEntry)other);
    }

    public boolean equals(FieldEntry other) {
        return ((ClassEntry)this.parent).equals((ClassEntry)other.parent) && this.name.equals(other.name) && this.desc.equals(other.desc);
    }

    @Override
    public boolean canConflictWith(Entry<?> entry) {
        return entry instanceof FieldEntry && ((ClassEntry)((FieldEntry)entry).parent).equals((ClassEntry)this.parent);
    }

    public String toString() {
        return ((ClassEntry)this.parent).getFullName() + "." + this.name + ":" + this.desc;
    }

    @Override
    public int compareTo(FieldEntry entry) {
        return (this.name + this.desc.toString()).compareTo(entry.name + entry.desc.toString());
    }
}

