/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.source;

import cuchaz.enigma.source.Token;
import java.util.HashMap;
import java.util.Map;

public class SourceRemapper {
    private final String source;
    private final Iterable<Token> tokens;

    public SourceRemapper(String source, Iterable<Token> tokens) {
        this.source = source;
        this.tokens = tokens;
    }

    public Result remap(Remapper remapper) {
        StringBuffer remappedSource = new StringBuffer(this.source);
        HashMap<Token, Token> remappedTokens = new HashMap<Token, Token>();
        int accumulatedOffset = 0;
        for (Token token : this.tokens) {
            Token movedToken;
            String remappedName = remapper.remap(token, movedToken = token.move(accumulatedOffset));
            if (remappedName != null) {
                accumulatedOffset += movedToken.getRenameOffset(remappedName);
                movedToken.rename(remappedSource, remappedName);
            }
            if (token.equals(movedToken)) continue;
            remappedTokens.put(token, movedToken);
        }
        return new Result(remappedSource.toString(), remappedTokens);
    }

    public static interface Remapper {
        public String remap(Token var1, Token var2);
    }

    public static class Result {
        private final String remappedSource;
        private final Map<Token, Token> remappedTokens;

        Result(String remappedSource, Map<Token, Token> remappedTokens) {
            this.remappedSource = remappedSource;
            this.remappedTokens = remappedTokens;
        }

        public String getSource() {
            return this.remappedSource;
        }

        public Token getRemappedToken(Token token) {
            return this.remappedTokens.getOrDefault(token, token);
        }

        public boolean isEmpty() {
            return this.remappedTokens.isEmpty();
        }
    }
}

