/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.classhandle;

import cuchaz.enigma.EnigmaProject;
import cuchaz.enigma.classhandle.ClassHandle;
import cuchaz.enigma.classhandle.ClassHandleError;
import cuchaz.enigma.classprovider.CachingClassProvider;
import cuchaz.enigma.classprovider.ObfuscationFixClassProvider;
import cuchaz.enigma.events.ClassHandleListener;
import cuchaz.enigma.source.DecompiledClassSource;
import cuchaz.enigma.source.Decompiler;
import cuchaz.enigma.source.DecompilerService;
import cuchaz.enigma.source.Source;
import cuchaz.enigma.source.SourceIndex;
import cuchaz.enigma.source.SourceSettings;
import cuchaz.enigma.translation.representation.entry.ClassEntry;
import cuchaz.enigma.utils.Result;
import cuchaz.enigma.utils.Utils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.Nullable;

public final class ClassHandleProvider {
    private final EnigmaProject project;
    private final ExecutorService pool = Executors.newWorkStealingPool();
    private DecompilerService ds;
    private Decompiler decompiler;
    private final Map<ClassEntry, Entry> handles = new HashMap<ClassEntry, Entry>();
    private final ReadWriteLock lock = new ReentrantReadWriteLock();

    public ClassHandleProvider(EnigmaProject project, DecompilerService ds) {
        this.project = project;
        this.ds = ds;
        this.decompiler = this.createDecompiler();
    }

    @Nullable
    public ClassHandle openClass(ClassEntry entry) {
        if (!this.project.getJarIndex().getEntryIndex().hasClass(entry)) {
            return null;
        }
        return Utils.withLock(this.lock.writeLock(), () -> {
            Entry e = this.handles.computeIfAbsent(entry, entry1 -> new Entry(this, (ClassEntry)entry1));
            return e.createHandle();
        });
    }

    public void setDecompilerService(DecompilerService ds) {
        if (this.ds.equals(ds)) {
            return;
        }
        this.ds = ds;
        this.decompiler = this.createDecompiler();
        Utils.withLock(this.lock.readLock(), () -> this.handles.values().forEach(Entry::invalidate));
    }

    public DecompilerService getDecompilerService() {
        return this.ds;
    }

    private Decompiler createDecompiler() {
        return this.ds.create(new CachingClassProvider(new ObfuscationFixClassProvider(this.project.getClassProvider(), this.project.getJarIndex())), new SourceSettings(true, true));
    }

    public void invalidateMapped() {
        Utils.withLock(this.lock.readLock(), () -> this.handles.values().forEach(Entry::invalidateMapped));
    }

    public void invalidateMapped(ClassEntry entry) {
        Utils.withLock(this.lock.readLock(), () -> {
            Entry e = this.handles.get(entry);
            if (e != null) {
                e.invalidateMapped();
            }
        });
    }

    public void invalidateJavadoc(ClassEntry entry) {
        Utils.withLock(this.lock.readLock(), () -> {
            Entry e = this.handles.get(entry);
            if (e != null) {
                e.invalidateJavadoc();
            }
        });
    }

    private void deleteEntry(Entry entry) {
        Utils.withLock(this.lock.writeLock(), () -> this.handles.remove(entry.entry));
    }

    public void destroy() {
        this.pool.shutdown();
        try {
            this.pool.awaitTermination(30L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        Utils.withLock(this.lock.writeLock(), () -> {
            this.handles.values().forEach(Entry::destroy);
            this.handles.clear();
        });
    }

    private static final class ClassHandleImpl
    implements ClassHandle {
        private final Entry entry;
        private boolean valid = true;
        private final Set<ClassHandleListener> listeners = new HashSet<ClassHandleListener>();

        private ClassHandleImpl(Entry entry) {
            this.entry = entry;
        }

        @Override
        public ClassEntry getRef() {
            this.checkValid();
            return this.entry.entry;
        }

        @Override
        @Nullable
        public ClassEntry getDeobfRef() {
            this.checkValid();
            return this.entry.getDeobfRef();
        }

        @Override
        public CompletableFuture<Result<DecompiledClassSource, ClassHandleError>> getSource() {
            this.checkValid();
            return this.entry.getSourceAsync();
        }

        @Override
        public CompletableFuture<Result<Source, ClassHandleError>> getUncommentedSource() {
            this.checkValid();
            return this.entry.getUncommentedSourceAsync();
        }

        @Override
        public void invalidate() {
            this.checkValid();
            this.entry.invalidate();
        }

        @Override
        public void invalidateMapped() {
            this.checkValid();
            this.entry.invalidateMapped();
        }

        @Override
        public void invalidateJavadoc() {
            this.checkValid();
            this.entry.invalidateJavadoc();
        }

        public void onUncommentedSourceChanged(Result<Source, ClassHandleError> source) {
            this.listeners.forEach(l -> l.onUncommentedSourceChanged(this, source));
        }

        public void onDocsChanged(Result<Source, ClassHandleError> source) {
            this.listeners.forEach(l -> l.onDocsChanged(this, source));
        }

        public void onMappedSourceChanged(Result<DecompiledClassSource, ClassHandleError> source) {
            this.listeners.forEach(l -> l.onMappedSourceChanged(this, source));
        }

        public void onInvalidate(ClassHandleListener.InvalidationType t) {
            this.listeners.forEach(l -> l.onInvalidate(this, t));
        }

        public void onDeobfRefChanged(ClassEntry newDeobf) {
            this.listeners.forEach(l -> l.onDeobfRefChanged(this, newDeobf));
        }

        @Override
        public void addListener(ClassHandleListener listener) {
            this.listeners.add(listener);
        }

        @Override
        public void removeListener(ClassHandleListener listener) {
            this.listeners.remove(listener);
        }

        @Override
        public ClassHandle copy() {
            this.checkValid();
            return this.entry.createHandle();
        }

        @Override
        public void close() {
            if (this.valid) {
                this.entry.closeHandle(this);
            }
        }

        private void checkValid() {
            if (!this.valid) {
                throw new IllegalStateException("Class handle no longer valid");
            }
        }

        public void destroy() {
            this.listeners.forEach(l -> l.onDeleted(this));
            this.valid = false;
        }
    }

    private static final class Entry {
        private final ClassHandleProvider p;
        private final ClassEntry entry;
        private ClassEntry deobfRef;
        private final List<ClassHandleImpl> handles = new ArrayList<ClassHandleImpl>();
        private Result<Source, ClassHandleError> uncommentedSource;
        private Result<DecompiledClassSource, ClassHandleError> source;
        private final List<CompletableFuture<Result<Source, ClassHandleError>>> waitingUncommentedSources = Collections.synchronizedList(new ArrayList());
        private final List<CompletableFuture<Result<DecompiledClassSource, ClassHandleError>>> waitingSources = Collections.synchronizedList(new ArrayList());
        private final AtomicInteger decompileVersion = new AtomicInteger();
        private final AtomicInteger javadocVersion = new AtomicInteger();
        private final AtomicInteger indexVersion = new AtomicInteger();
        private final AtomicInteger mappedVersion = new AtomicInteger();
        private final ReadWriteLock lock = new ReentrantReadWriteLock();

        private Entry(ClassHandleProvider p, ClassEntry entry) {
            this.p = p;
            this.entry = entry;
            this.deobfRef = p.project.getMapper().deobfuscate(entry);
            this.invalidate();
        }

        public ClassHandleImpl createHandle() {
            ClassHandleImpl handle = new ClassHandleImpl(this);
            Utils.withLock(this.lock.writeLock(), () -> this.handles.add(handle));
            return handle;
        }

        @Nullable
        public ClassEntry getDeobfRef() {
            return this.deobfRef;
        }

        private void checkDeobfRefForUpdate() {
            ClassEntry newDeobf = this.p.project.getMapper().deobfuscate(this.entry);
            if (!Objects.equals(this.deobfRef, newDeobf)) {
                this.deobfRef = newDeobf;
                Utils.withLock(this.lock.readLock(), () -> new ArrayList<ClassHandleImpl>(this.handles)).forEach(h2 -> h2.onDeobfRefChanged(newDeobf));
            }
        }

        public void invalidate() {
            this.checkDeobfRefForUpdate();
            Utils.withLock(this.lock.readLock(), () -> new ArrayList<ClassHandleImpl>(this.handles)).forEach(h2 -> h2.onInvalidate(ClassHandleListener.InvalidationType.FULL));
            this.continueMapSource(this.continueIndexSource(this.continueInsertJavadoc(this.decompile())));
        }

        public void invalidateJavadoc() {
            this.checkDeobfRefForUpdate();
            Utils.withLock(this.lock.readLock(), () -> new ArrayList<ClassHandleImpl>(this.handles)).forEach(h2 -> h2.onInvalidate(ClassHandleListener.InvalidationType.JAVADOC));
            this.continueMapSource(this.continueIndexSource(this.continueInsertJavadoc(CompletableFuture.completedFuture(this.uncommentedSource))));
        }

        public void invalidateMapped() {
            this.checkDeobfRefForUpdate();
            Utils.withLock(this.lock.readLock(), () -> new ArrayList<ClassHandleImpl>(this.handles)).forEach(h2 -> h2.onInvalidate(ClassHandleListener.InvalidationType.MAPPINGS));
            this.continueMapSource(CompletableFuture.completedFuture(this.source));
        }

        private CompletableFuture<Result<Source, ClassHandleError>> decompile() {
            int v = this.decompileVersion.incrementAndGet();
            return CompletableFuture.supplyAsync(() -> {
                Result _uncommentedSource;
                if (this.decompileVersion.get() != v) {
                    return null;
                }
                try {
                    _uncommentedSource = Result.ok(this.p.decompiler.getSource(this.entry.getFullName()));
                }
                catch (Throwable e) {
                    return Result.err(ClassHandleError.decompile(e));
                }
                Result uncommentedSource = _uncommentedSource;
                this.uncommentedSource = uncommentedSource;
                this.waitingUncommentedSources.forEach(f -> f.complete(uncommentedSource));
                this.waitingUncommentedSources.clear();
                Utils.withLock(this.lock.readLock(), () -> new ArrayList<ClassHandleImpl>(this.handles)).forEach(h2 -> h2.onUncommentedSourceChanged(uncommentedSource));
                return uncommentedSource;
            }, this.p.pool);
        }

        private CompletableFuture<Result<Source, ClassHandleError>> continueInsertJavadoc(CompletableFuture<Result<Source, ClassHandleError>> f) {
            int v = this.javadocVersion.incrementAndGet();
            return f.thenApplyAsync(res -> {
                if (res == null || this.javadocVersion.get() != v) {
                    return null;
                }
                Result jdSource = res.map(s2 -> s2.addJavadocs(this.p.project.getMapper()));
                Utils.withLock(this.lock.readLock(), () -> new ArrayList<ClassHandleImpl>(this.handles)).forEach(h2 -> h2.onDocsChanged(jdSource));
                return jdSource;
            }, (Executor)this.p.pool);
        }

        private CompletableFuture<Result<DecompiledClassSource, ClassHandleError>> continueIndexSource(CompletableFuture<Result<Source, ClassHandleError>> f) {
            int v = this.indexVersion.incrementAndGet();
            return f.thenApplyAsync(res -> {
                if (res == null || this.indexVersion.get() != v) {
                    return null;
                }
                return res.andThen(jdSource -> {
                    SourceIndex index = jdSource.index();
                    index.resolveReferences(this.p.project.getMapper().getObfResolver());
                    DecompiledClassSource source = new DecompiledClassSource(this.entry, index);
                    return Result.ok(source);
                });
            }, (Executor)this.p.pool);
        }

        private void continueMapSource(CompletableFuture<Result<DecompiledClassSource, ClassHandleError>> f) {
            int v = this.mappedVersion.incrementAndGet();
            f.thenAcceptAsync(res -> {
                if (res == null || this.mappedVersion.get() != v) {
                    return;
                }
                res = res.andThen(source -> {
                    try {
                        DecompiledClassSource remappedSource = source.remapSource(this.p.project, this.p.project.getMapper().getDeobfuscator());
                        return Result.ok(remappedSource);
                    }
                    catch (Throwable e) {
                        return Result.err(ClassHandleError.remap(e));
                    }
                });
                this.source = res;
                this.waitingSources.forEach(s2 -> s2.complete(this.source));
                this.waitingSources.clear();
                Utils.withLock(this.lock.readLock(), () -> new ArrayList<ClassHandleImpl>(this.handles)).forEach(h2 -> h2.onMappedSourceChanged(this.source));
            }, (Executor)this.p.pool);
        }

        public void closeHandle(ClassHandleImpl classHandle) {
            classHandle.destroy();
            Utils.withLock(this.lock.writeLock(), () -> {
                this.handles.remove(classHandle);
                if (this.handles.isEmpty()) {
                    this.p.deleteEntry(this);
                }
            });
        }

        public void destroy() {
            Utils.withLock(this.lock.writeLock(), () -> {
                this.handles.forEach(ClassHandleImpl::destroy);
                this.handles.clear();
            });
        }

        public CompletableFuture<Result<Source, ClassHandleError>> getUncommentedSourceAsync() {
            if (this.uncommentedSource != null) {
                return CompletableFuture.completedFuture(this.uncommentedSource);
            }
            CompletableFuture<Result<Source, ClassHandleError>> f = new CompletableFuture<Result<Source, ClassHandleError>>();
            this.waitingUncommentedSources.add(f);
            return f;
        }

        public CompletableFuture<Result<DecompiledClassSource, ClassHandleError>> getSourceAsync() {
            if (this.source != null) {
                return CompletableFuture.completedFuture(this.source);
            }
            CompletableFuture<Result<DecompiledClassSource, ClassHandleError>> f = new CompletableFuture<Result<DecompiledClassSource, ClassHandleError>>();
            this.waitingSources.add(f);
            return f;
        }
    }
}

