/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.translation.representation.entry;

import com.google.common.base.Preconditions;
import cuchaz.enigma.source.RenamableTokenType;
import cuchaz.enigma.translation.TranslateResult;
import cuchaz.enigma.translation.Translator;
import cuchaz.enigma.translation.mapping.EntryMapping;
import cuchaz.enigma.translation.representation.AccessFlags;
import cuchaz.enigma.translation.representation.Signature;
import cuchaz.enigma.translation.representation.entry.ClassEntry;
import cuchaz.enigma.translation.representation.entry.DefEntry;
import java.util.Arrays;
import javax.annotation.Nullable;

public class ClassDefEntry
extends ClassEntry
implements DefEntry<ClassEntry> {
    private final AccessFlags access;
    private final Signature signature;
    private final ClassEntry superClass;
    private final ClassEntry[] interfaces;

    public ClassDefEntry(String className, Signature signature, AccessFlags access, @Nullable ClassEntry superClass, ClassEntry[] interfaces) {
        this(ClassDefEntry.getOuterClass(className), ClassDefEntry.getInnerName(className), signature, access, superClass, interfaces, null);
    }

    public ClassDefEntry(ClassEntry parent, String className, Signature signature, AccessFlags access, @Nullable ClassEntry superClass, ClassEntry[] interfaces) {
        this(parent, className, signature, access, superClass, interfaces, null);
    }

    public ClassDefEntry(ClassEntry parent, String className, Signature signature, AccessFlags access, @Nullable ClassEntry superClass, ClassEntry[] interfaces, String javadocs) {
        super(parent, className, javadocs);
        Preconditions.checkNotNull(signature, "Class signature cannot be null");
        Preconditions.checkNotNull(access, "Class access cannot be null");
        this.signature = signature;
        this.access = access;
        this.superClass = superClass;
        this.interfaces = interfaces != null ? interfaces : new ClassEntry[]{};
    }

    public static ClassDefEntry parse(int access, String name, String signature, String superName, String[] interfaces) {
        ClassEntry superClass = superName != null ? new ClassEntry(superName) : null;
        ClassEntry[] interfaceClasses = (ClassEntry[])Arrays.stream(interfaces).map(ClassEntry::new).toArray(ClassEntry[]::new);
        return new ClassDefEntry(name, Signature.createSignature(signature), new AccessFlags(access), superClass, interfaceClasses);
    }

    public Signature getSignature() {
        return this.signature;
    }

    @Override
    public AccessFlags getAccess() {
        return this.access;
    }

    @Nullable
    public ClassEntry getSuperClass() {
        return this.superClass;
    }

    public ClassEntry[] getInterfaces() {
        return this.interfaces;
    }

    @Override
    public TranslateResult<ClassDefEntry> extendedTranslate(Translator translator, @Nullable EntryMapping mapping) {
        Signature translatedSignature = translator.translate(this.signature);
        String translatedName = mapping != null ? mapping.getTargetName() : this.name;
        AccessFlags translatedAccess = mapping != null ? mapping.getAccessModifier().transform(this.access) : this.access;
        ClassEntry translatedSuper = translator.translate(this.superClass);
        ClassEntry[] translatedInterfaces = (ClassEntry[])Arrays.stream(this.interfaces).map(translator::translate).toArray(ClassEntry[]::new);
        String docs = mapping != null ? mapping.getJavadoc() : null;
        return TranslateResult.of(mapping == null ? RenamableTokenType.OBFUSCATED : RenamableTokenType.DEOBFUSCATED, new ClassDefEntry((ClassEntry)this.parent, translatedName, translatedSignature, translatedAccess, translatedSuper, translatedInterfaces, docs));
    }

    @Override
    public ClassDefEntry withName(String name) {
        return new ClassDefEntry((ClassEntry)this.parent, name, this.signature, this.access, this.superClass, this.interfaces, this.javadocs);
    }

    @Override
    public ClassDefEntry withParent(ClassEntry parent) {
        return new ClassDefEntry(parent, this.name, this.signature, this.access, this.superClass, this.interfaces, this.javadocs);
    }
}

