/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.source.cfr;

import cuchaz.enigma.classprovider.ClassProvider;
import cuchaz.enigma.source.Decompiler;
import cuchaz.enigma.source.Source;
import cuchaz.enigma.source.SourceSettings;
import cuchaz.enigma.source.cfr.CfrSource;
import cuchaz.enigma.utils.AsmUtil;
import java.util.Collection;
import java.util.HashMap;
import org.benf.cfr.reader.apiunreleased.ClassFileSource2;
import org.benf.cfr.reader.apiunreleased.JarContent;
import org.benf.cfr.reader.bytecode.analysis.parse.utils.Pair;
import org.benf.cfr.reader.entities.ClassFile;
import org.benf.cfr.reader.mapping.MappingFactory;
import org.benf.cfr.reader.mapping.ObfuscationMapping;
import org.benf.cfr.reader.relationship.MemberNameResolver;
import org.benf.cfr.reader.state.DCCommonState;
import org.benf.cfr.reader.state.TypeUsageCollectingDumper;
import org.benf.cfr.reader.util.AnalysisType;
import org.benf.cfr.reader.util.CannotLoadClassException;
import org.benf.cfr.reader.util.collections.ListFactory;
import org.benf.cfr.reader.util.getopt.Options;
import org.benf.cfr.reader.util.getopt.OptionsImpl;
import org.objectweb.asm.tree.ClassNode;

public class CfrDecompiler
implements Decompiler {
    private final DCCommonState state;

    public CfrDecompiler(final ClassProvider classProvider, SourceSettings sourceSettings) {
        HashMap<String, String> options = new HashMap<String, String>();
        this.state = new DCCommonState(OptionsImpl.getFactory().create(options), new ClassFileSource2(){

            @Override
            public JarContent addJarContent(String s2, AnalysisType analysisType) {
                return null;
            }

            @Override
            public void informAnalysisRelativePathDetail(String usePath, String classFilePath) {
            }

            @Override
            public Collection<String> addJar(String jarPath) {
                return null;
            }

            @Override
            public String getPossiblyRenamedPath(String path) {
                return path;
            }

            @Override
            public Pair<byte[], String> getClassFileContent(String path) {
                ClassNode node = classProvider.get(path.substring(0, path.lastIndexOf(46)));
                if (node == null) {
                    return null;
                }
                return new Pair<byte[], String>(AsmUtil.nodeToBytes(node), path);
            }
        });
    }

    @Override
    public Source getSource(String className) {
        DCCommonState state = this.state;
        Options options = state.getOptions();
        ObfuscationMapping mapping = MappingFactory.get(options, state);
        state = new DCCommonState(state, mapping);
        ClassFile tree = state.getClassFileMaybePath(className);
        state.configureWith(tree);
        try {
            tree = state.getClassFile(tree.getClassType());
        }
        catch (CannotLoadClassException cannotLoadClassException) {
            // empty catch block
        }
        if (((Boolean)options.getOption(OptionsImpl.DECOMPILE_INNER_CLASSES)).booleanValue()) {
            tree.loadInnerClasses(state);
        }
        if (((Boolean)options.getOption(OptionsImpl.RENAME_DUP_MEMBERS)).booleanValue()) {
            MemberNameResolver.resolveNames(state, ListFactory.newList(state.getClassCache().getLoadedTypes()));
        }
        TypeUsageCollectingDumper typeUsageCollector = new TypeUsageCollectingDumper(options, tree);
        tree.analyseTop(state, typeUsageCollector);
        return new CfrSource(tree, state, typeUsageCollector.getRealTypeUsageInformation());
    }
}

