/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.config;

import cuchaz.enigma.config.ConfigSection;
import cuchaz.enigma.config.ConfigStructureVisitor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public final class ConfigSerializer {
    private static final Pattern FULL_RGB_COLOR = Pattern.compile("#[0-9A-Fa-f]{6}");
    private static final Pattern MIN_RGB_COLOR = Pattern.compile("#[0-9A-Fa-f]{3}");
    private static final int UNEXPECTED_TOKEN = -1;
    private static final int NO_MATCH = -2;

    public static void parse(String v, ConfigStructureVisitor visitor) {
        int i;
        String[] lines = v.split("\n");
        int len = lines.length;
        for (i = len - 2; i >= 0; --i) {
            if (!lines[i].endsWith("\\")) continue;
            lines[i] = String.format("%s\n%s", lines[i], lines[i + 1]);
            --len;
        }
        for (i = 0; i < len; ++i) {
            String line = lines[i];
            if (line.trim().isEmpty() || line.trim().startsWith(";")) continue;
            int r = ConfigSerializer.parseSectionLine(line, 0, visitor);
            boolean bl = r == -2 && (r = ConfigSerializer.parseKeyValue(line, 0, visitor)) == -2;
        }
    }

    private static int parseSectionLine(String v, int idx, ConfigStructureVisitor visitor) {
        if (v.startsWith("[")) {
            ArrayList<String> path = new ArrayList<String>();
            while (idx < v.length() && v.charAt(idx) == '[') {
                if ((idx = ConfigSerializer.parseSection(v, idx, path)) != -1) continue;
                return -1;
            }
            if (!path.isEmpty()) {
                visitor.jumpToRootSection();
                for (String s2 : path) {
                    visitor.visitSection(s2);
                }
            }
            return v.length();
        }
        return -2;
    }

    private static int parseSection(String v, int idx, List<String> path) {
        ++idx;
        StringBuilder sb = new StringBuilder();
        while (idx < v.length()) {
            int nextEscape;
            int nextCloseBracket = v.indexOf(93, idx);
            int next = ConfigSerializer.optMin(nextCloseBracket, nextEscape = v.indexOf(92, idx));
            if (next == -1) {
                return -1;
            }
            if (next == nextCloseBracket) {
                sb.append(v, idx, nextCloseBracket);
                path.add(sb.toString());
                return nextCloseBracket + 1;
            }
            if (next != nextEscape) continue;
            sb.append(v, idx, nextEscape);
            idx = ConfigSerializer.parseEscape(v, nextEscape, sb);
        }
        return idx;
    }

    private static int parseKeyValue(String v, int idx, ConfigStructureVisitor visitor) {
        int nextEscape;
        int nextEscape2;
        int nextEq;
        int next;
        StringBuilder sb = new StringBuilder();
        String k = null;
        while (idx < v.length() && (next = ConfigSerializer.optMin(nextEq = v.indexOf(61, idx), nextEscape2 = v.indexOf(92, idx))) != -1) {
            if (next == nextEq) {
                sb.append(v, idx, nextEq);
                k = sb.toString();
                sb.delete(0, sb.length());
                idx = nextEq + 1;
                break;
            }
            if (next != nextEscape2) continue;
            sb.append(v, idx, nextEscape2);
            idx = ConfigSerializer.parseEscape(v, nextEscape2, sb);
        }
        while (idx < v.length() && (nextEscape = v.indexOf(92, idx)) != -1) {
            sb.append(v, idx, nextEscape);
            idx = ConfigSerializer.parseEscape(v, nextEscape, sb);
        }
        sb.append(v, idx, v.length());
        if (k == null) {
            return -2;
        }
        visitor.visitKeyValue(k, sb.toString());
        return idx;
    }

    private static int parseEscape(String v, int idx, StringBuilder sb) {
        if (idx + 1 < v.length()) {
            if (v.charAt(idx + 1) == 'u') {
                if (idx + 5 < v.length()) {
                    String codePoint = v.substring(idx + 2, idx + 6);
                    try {
                        int c = Integer.parseUnsignedInt(codePoint, 16);
                        sb.append((char)c);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    idx += 6;
                }
            } else if (v.charAt(idx + 1) == 'n') {
                sb.append('\n');
                idx += 2;
            } else {
                sb.append(v.charAt(idx + 1));
                idx += 2;
            }
        } else {
            ++idx;
        }
        return idx;
    }

    public static String structureToString(ConfigSection section) {
        StringBuilder sb = new StringBuilder();
        ConfigSerializer.structureToString(section, sb, new ArrayList<String>());
        return sb.toString();
    }

    private static void structureToString(ConfigSection section, StringBuilder sb, List<String> pathStack) {
        if (!section.values().isEmpty()) {
            if (sb.length() > 0) {
                sb.append('\n');
            }
            pathStack.forEach(n -> sb.append('[').append(ConfigSerializer.escapeSection(n)).append(']'));
            if (!pathStack.isEmpty()) {
                sb.append('\n');
            }
            section.values().entrySet().stream().sorted(Map.Entry.comparingByKey()).forEach(e -> sb.append(ConfigSerializer.escapeKey((String)e.getKey())).append('=').append(ConfigSerializer.escapeValue((String)e.getValue())).append('\n'));
        }
        section.sections().entrySet().stream().sorted(Map.Entry.comparingByKey()).forEach(e -> {
            pathStack.add((String)e.getKey());
            ConfigSerializer.structureToString((ConfigSection)e.getValue(), sb, pathStack);
            pathStack.remove(pathStack.size() - 1);
        });
    }

    private static String escapeSection(String s2) {
        return s2.replace("\\", "\\\\").replace("\n", "\\n").replace("]", "\\]").chars().mapToObj(c -> c >= 32 && c < 127 ? Character.toString((char)c) : String.format("\\u%04x", c)).collect(Collectors.joining());
    }

    private static String escapeKey(String s2) {
        return s2.replace("\\", "\\\\").replace("[", "\\[").replace("\n", "\\n").replace("=", "\\=").chars().mapToObj(c -> c >= 32 && c < 127 ? Character.toString((char)c) : String.format("\\u%04x", c)).collect(Collectors.joining());
    }

    private static String escapeValue(String s2) {
        return s2.replace("\\", "\\\\").replace("\n", "\\n").chars().mapToObj(c -> c >= 32 && c < 127 ? Character.toString((char)c) : String.format("\\u%04x", c)).collect(Collectors.joining());
    }

    public static Optional<Boolean> parseBool(String v) {
        if (v == null) {
            return Optional.empty();
        }
        switch (v) {
            case "true": {
                return Optional.of(true);
            }
            case "false": {
                return Optional.of(false);
            }
        }
        return Optional.empty();
    }

    public static OptionalInt parseInt(String v) {
        if (v == null) {
            return OptionalInt.empty();
        }
        try {
            return OptionalInt.of(Integer.parseInt(v));
        }
        catch (NumberFormatException e) {
            return OptionalInt.empty();
        }
    }

    public static OptionalDouble parseDouble(String v) {
        if (v == null) {
            return OptionalDouble.empty();
        }
        try {
            return OptionalDouble.of(Double.parseDouble(v));
        }
        catch (NumberFormatException e) {
            return OptionalDouble.empty();
        }
    }

    public static OptionalInt parseRgbColor(String v) {
        if (v == null) {
            return OptionalInt.empty();
        }
        try {
            if (FULL_RGB_COLOR.matcher(v).matches()) {
                return OptionalInt.of(Integer.parseUnsignedInt(v.substring(1), 16));
            }
            if (MIN_RGB_COLOR.matcher(v).matches()) {
                int result = Integer.parseUnsignedInt(v.substring(1), 16);
                result = result & 0xF | (result & 0xF0) << 4 | (result & 0xF00) << 8;
                result |= result << 4;
                return OptionalInt.of(result);
            }
            return OptionalInt.empty();
        }
        catch (NumberFormatException e) {
            return OptionalInt.empty();
        }
    }

    public static String rgbColorToString(int color) {
        boolean isShort;
        boolean bl = isShort = (((color &= 0xFFFFFF) & 0xF0F0F0) >> 4 ^ color & 0xF0F0F) == 0;
        if (isShort) {
            int packed = color & 0xF0F0F;
            packed = packed & 0xF | packed >> 4;
            packed = packed & 0xFF | (packed & 0xFFFFFF00) >> 4;
            return String.format("#%03x", packed);
        }
        return String.format("#%06x", color);
    }

    public static Optional<String[]> parseArray(String v) {
        if (v == null) {
            return Optional.empty();
        }
        ArrayList<String> l = new ArrayList<String>();
        int idx = 0;
        StringBuilder cur = new StringBuilder();
        while (true) {
            int nextEsc;
            int nextSep;
            int next;
            if ((next = ConfigSerializer.optMin(nextSep = v.indexOf(44, idx), nextEsc = v.indexOf(92, idx))) == -1) {
                cur.append(v, idx, v.length());
                l.add(cur.toString());
                return Optional.of(l.toArray(new String[0]));
            }
            if (next == nextSep) {
                cur.append(v, idx, nextSep);
                l.add(cur.toString());
                cur.delete(0, cur.length());
                idx = nextSep + 1;
                continue;
            }
            if (next != nextEsc) continue;
            cur.append(v, idx, nextEsc);
            if (nextEsc + 1 < v.length()) {
                cur.append(v.charAt(nextEsc + 1));
            }
            idx = nextEsc + 2;
        }
    }

    public static String arrayToString(String[] values) {
        return Arrays.stream(values).map(s2 -> s2.replace("\\", "\\\\").replace(",", "\\,")).collect(Collectors.joining(","));
    }

    public static <T extends Enum<T>> Optional<T> parseEnum(Function<String, T> byName, String v) {
        if (v == null) {
            return Optional.empty();
        }
        try {
            return Optional.of(byName.apply(v));
        }
        catch (IllegalArgumentException e) {
            return Optional.empty();
        }
    }

    private static int optMin(int v1, int v2) {
        if (v1 == -1) {
            return v2;
        }
        if (v2 == -1) {
            return v1;
        }
        return Math.min(v1, v2);
    }
}

