/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma;

import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import cuchaz.enigma.api.service.EnigmaServiceType;
import cuchaz.enigma.translation.mapping.serde.MappingFileNameFormat;
import cuchaz.enigma.translation.mapping.serde.MappingSaveParameters;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;

public final class EnigmaProfile {
    public static final EnigmaProfile EMPTY = new EnigmaProfile(new ServiceContainer(ImmutableMap.of()));
    private static final MappingSaveParameters DEFAULT_MAPPING_SAVE_PARAMETERS = new MappingSaveParameters(MappingFileNameFormat.BY_DEOBF);
    private static final Gson GSON = new GsonBuilder().registerTypeAdapter((Type)((Object)ServiceContainer.class), EnigmaProfile::loadServiceContainer).create();
    private static final Type SERVICE_LIST_TYPE = new TypeToken<List<Service>>(){}.getType();
    @SerializedName(value="services")
    private final ServiceContainer serviceProfiles;
    @SerializedName(value="mapping_save_parameters")
    private final MappingSaveParameters mappingSaveParameters = null;

    private EnigmaProfile(ServiceContainer serviceProfiles) {
        this.serviceProfiles = serviceProfiles;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static EnigmaProfile read(@Nullable Path file) throws IOException {
        if (file != null) {
            try (BufferedReader reader2 = Files.newBufferedReader(file);){
                EnigmaProfile enigmaProfile2 = EnigmaProfile.parse(reader2);
                return enigmaProfile2;
            }
        }
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(EnigmaProfile.class.getResourceAsStream("/profile.json"), StandardCharsets.UTF_8));){
            EnigmaProfile enigmaProfile = EnigmaProfile.parse(reader);
            return enigmaProfile;
        }
        catch (IOException ex) {
            System.err.println("Failed to load default profile, will use empty profile: " + ex.getMessage());
            return EMPTY;
        }
    }

    public static EnigmaProfile parse(Reader reader) {
        return GSON.fromJson(reader, EnigmaProfile.class);
    }

    private static ServiceContainer loadServiceContainer(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        if (!json.isJsonObject()) {
            throw new JsonParseException("services must be an Object!");
        }
        JsonObject object = json.getAsJsonObject();
        ImmutableMap.Builder<String, List<Service>> builder = ImmutableMap.builder();
        for (Map.Entry<String, JsonElement> entry : object.entrySet()) {
            JsonElement value = entry.getValue();
            if (value.isJsonObject()) {
                builder.put(entry.getKey(), Collections.singletonList(GSON.fromJson(value, Service.class)));
                continue;
            }
            if (value.isJsonArray()) {
                builder.put(entry.getKey(), (List<Service>)GSON.fromJson(value, SERVICE_LIST_TYPE));
                continue;
            }
            throw new JsonParseException(String.format("Don't know how to convert %s to a list of service!", value));
        }
        return new ServiceContainer(builder.build());
    }

    public List<Service> getServiceProfiles(EnigmaServiceType<?> serviceType) {
        return this.serviceProfiles.get(serviceType.key);
    }

    public MappingSaveParameters getMappingSaveParameters() {
        return this.mappingSaveParameters == null ? DEFAULT_MAPPING_SAVE_PARAMETERS : this.mappingSaveParameters;
    }

    static final class ServiceContainer {
        private final Map<String, List<Service>> services;

        ServiceContainer(Map<String, List<Service>> services) {
            this.services = services;
        }

        List<Service> get(String key) {
            return this.services.getOrDefault(key, Collections.emptyList());
        }
    }

    public static class Service {
        private final String id;
        private final Map<String, String> args;

        Service(String id, Map<String, String> args) {
            this.id = id;
            this.args = args;
        }

        public boolean matches(String id) {
            return this.id.equals(id);
        }

        public Optional<String> getArgument(String key) {
            return this.args != null ? Optional.ofNullable(this.args.get(key)) : Optional.empty();
        }
    }
}

