/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableListMultimap;
import cuchaz.enigma.EnigmaProfile;
import cuchaz.enigma.EnigmaProject;
import cuchaz.enigma.EnigmaServices;
import cuchaz.enigma.ProgressListener;
import cuchaz.enigma.analysis.index.JarIndex;
import cuchaz.enigma.api.EnigmaPlugin;
import cuchaz.enigma.api.EnigmaPluginContext;
import cuchaz.enigma.api.service.EnigmaService;
import cuchaz.enigma.api.service.EnigmaServiceFactory;
import cuchaz.enigma.api.service.EnigmaServiceType;
import cuchaz.enigma.api.service.JarIndexerService;
import cuchaz.enigma.classprovider.CachingClassProvider;
import cuchaz.enigma.classprovider.ClassProvider;
import cuchaz.enigma.classprovider.CombiningClassProvider;
import cuchaz.enigma.classprovider.JarClassProvider;
import cuchaz.enigma.utils.Utils;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import java.util.ServiceLoader;
import java.util.Set;

public class Enigma {
    public static final String NAME = "Enigma";
    public static final String VERSION;
    public static final String URL = "https://fabricmc.net";
    public static final int ASM_VERSION = 524288;
    private final EnigmaProfile profile;
    private final EnigmaServices services;

    private Enigma(EnigmaProfile profile, EnigmaServices services) {
        this.profile = profile;
        this.services = services;
    }

    public static Enigma create() {
        return new Builder().build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public EnigmaProject openJar(Path path, ClassProvider libraryClassProvider, ProgressListener progress) throws IOException {
        JarClassProvider jarClassProvider = new JarClassProvider(path);
        CachingClassProvider classProvider = new CachingClassProvider(new CombiningClassProvider(jarClassProvider, libraryClassProvider));
        Set<String> scope = jarClassProvider.getClassNames();
        JarIndex index = JarIndex.empty();
        index.indexJar(scope, classProvider, progress);
        this.services.get(JarIndexerService.TYPE).forEach(indexer -> indexer.acceptJar(scope, classProvider, index));
        return new EnigmaProject(this, path, classProvider, index, Utils.zipSha1(path));
    }

    public EnigmaProfile getProfile() {
        return this.profile;
    }

    public EnigmaServices getServices() {
        return this.services;
    }

    static {
        String version = null;
        try {
            version = Utils.readResourceToString("/version.txt");
        }
        catch (Throwable t) {
            version = "Unknown Version";
        }
        VERSION = version;
    }

    private static class PluginContext
    implements EnigmaPluginContext {
        private final EnigmaProfile profile;
        private final ImmutableListMultimap.Builder<EnigmaServiceType<?>, EnigmaService> services = ImmutableListMultimap.builder();

        PluginContext(EnigmaProfile profile) {
            this.profile = profile;
        }

        @Override
        public <T extends EnigmaService> void registerService(String id, EnigmaServiceType<T> serviceType, EnigmaServiceFactory<T> factory) {
            List<EnigmaProfile.Service> serviceProfiles = this.profile.getServiceProfiles(serviceType);
            for (EnigmaProfile.Service serviceProfile : serviceProfiles) {
                if (!serviceProfile.matches(id)) continue;
                T service = factory.create(serviceProfile::getArgument);
                this.services.put(serviceType, service);
                break;
            }
        }

        EnigmaServices buildServices() {
            return new EnigmaServices((ImmutableListMultimap<EnigmaServiceType<?>, EnigmaService>)this.services.build());
        }
    }

    public static class Builder {
        private EnigmaProfile profile = EnigmaProfile.EMPTY;
        private Iterable<EnigmaPlugin> plugins = ServiceLoader.load(EnigmaPlugin.class);

        private Builder() {
        }

        public Builder setProfile(EnigmaProfile profile) {
            Preconditions.checkNotNull(profile, "profile cannot be null");
            this.profile = profile;
            return this;
        }

        public Builder setPlugins(Iterable<EnigmaPlugin> plugins) {
            Preconditions.checkNotNull(plugins, "plugins cannot be null");
            this.plugins = plugins;
            return this;
        }

        public Enigma build() {
            PluginContext pluginContext = new PluginContext(this.profile);
            for (EnigmaPlugin plugin : this.plugins) {
                plugin.init(pluginContext);
            }
            EnigmaServices services = pluginContext.buildServices();
            return new Enigma(this.profile, services);
        }
    }
}

