/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.assembler.metadata;

import com.strobel.assembler.Collection;
import com.strobel.assembler.ir.attributes.SourceAttribute;
import com.strobel.assembler.metadata.FieldReference;
import com.strobel.assembler.metadata.Flags;
import com.strobel.assembler.metadata.IConstantValueProvider;
import com.strobel.assembler.metadata.IMemberDefinition;
import com.strobel.assembler.metadata.TypeDefinition;
import com.strobel.assembler.metadata.TypeReference;
import com.strobel.assembler.metadata.annotations.CustomAnnotation;
import com.strobel.core.HashUtilities;
import com.strobel.core.StringUtilities;
import java.util.Collections;
import java.util.List;
import javax.lang.model.element.Modifier;

public class FieldDefinition
extends FieldReference
implements IMemberDefinition,
IConstantValueProvider {
    private final Collection<CustomAnnotation> _customAnnotations;
    private final Collection<SourceAttribute> _sourceAttributes;
    private final List<CustomAnnotation> _customAnnotationsView;
    private final List<SourceAttribute> _sourceAttributesView;
    private String _name;
    private TypeReference _fieldType;
    private TypeDefinition _declaringType;
    private Object _constantValue;
    private long _flags;

    protected FieldDefinition(TypeReference fieldType) {
        this._fieldType = fieldType;
        this._customAnnotations = new Collection();
        this._customAnnotationsView = Collections.unmodifiableList(this._customAnnotations);
        this._sourceAttributes = new Collection();
        this._sourceAttributesView = Collections.unmodifiableList(this._sourceAttributes);
    }

    @Override
    public final List<CustomAnnotation> getAnnotations() {
        return this._customAnnotationsView;
    }

    protected final Collection<CustomAnnotation> getAnnotationsInternal() {
        return this._customAnnotations;
    }

    public final List<SourceAttribute> getSourceAttributes() {
        return this._sourceAttributesView;
    }

    protected final Collection<SourceAttribute> getSourceAttributesInternal() {
        return this._sourceAttributes;
    }

    public int hashCode() {
        return HashUtilities.hashCode(this.getFullName());
    }

    public boolean equals(Object obj) {
        if (obj instanceof FieldDefinition) {
            FieldDefinition other = (FieldDefinition)obj;
            return StringUtilities.equals(this.getName(), other.getName()) && this.typeNamesMatch(this.getDeclaringType(), other.getDeclaringType());
        }
        return false;
    }

    private boolean typeNamesMatch(TypeReference t1, TypeReference t2) {
        return t1 != null && t2 != null && StringUtilities.equals(t1.getFullName(), t2.getFullName());
    }

    public final boolean isEnumConstant() {
        return Flags.testAny(this.getFlags(), 16384L);
    }

    @Override
    public final boolean hasConstantValue() {
        return this._constantValue != null;
    }

    @Override
    public final Object getConstantValue() {
        return this._constantValue;
    }

    @Override
    public final TypeReference getFieldType() {
        return this._fieldType;
    }

    protected final void setFieldType(TypeReference fieldType) {
        this._fieldType = fieldType;
    }

    protected final void setConstantValue(Object constantValue) {
        this._constantValue = constantValue;
    }

    @Override
    public final String getName() {
        return this._name;
    }

    protected final void setName(String name) {
        this._name = name;
    }

    @Override
    public final boolean isDefinition() {
        return true;
    }

    @Override
    public final TypeDefinition getDeclaringType() {
        return this._declaringType;
    }

    protected final void setDeclaringType(TypeDefinition declaringType) {
        this._declaringType = declaringType;
    }

    @Override
    public final long getFlags() {
        return this._flags;
    }

    protected final void setFlags(long flags) {
        this._flags = flags;
    }

    @Override
    public final int getModifiers() {
        return Flags.toModifiers(this.getFlags());
    }

    @Override
    public final boolean isFinal() {
        return Flags.testAny(this.getFlags(), 16L);
    }

    @Override
    public final boolean isNonPublic() {
        return !Flags.testAny(this.getFlags(), 1L);
    }

    @Override
    public final boolean isPrivate() {
        return Flags.testAny(this.getFlags(), 2L);
    }

    @Override
    public final boolean isProtected() {
        return Flags.testAny(this.getFlags(), 4L);
    }

    @Override
    public final boolean isPublic() {
        return Flags.testAny(this.getFlags(), 1L);
    }

    @Override
    public final boolean isStatic() {
        return Flags.testAny(this.getFlags(), 8L);
    }

    @Override
    public final boolean isSynthetic() {
        return Flags.testAny(this.getFlags(), 4096L);
    }

    @Override
    public final boolean isDeprecated() {
        return Flags.testAny(this.getFlags(), 131072L);
    }

    @Override
    public final boolean isPackagePrivate() {
        return !Flags.testAny(this.getFlags(), 7L);
    }

    @Override
    public String getBriefDescription() {
        return this.appendBriefDescription(new StringBuilder()).toString();
    }

    @Override
    public String getDescription() {
        return this.appendDescription(new StringBuilder()).toString();
    }

    @Override
    public String getErasedDescription() {
        return this.appendErasedDescription(new StringBuilder()).toString();
    }

    @Override
    public String getSimpleDescription() {
        return this.appendSimpleDescription(new StringBuilder()).toString();
    }

    @Override
    protected StringBuilder appendName(StringBuilder sb, boolean fullName, boolean dottedName) {
        TypeDefinition declaringType;
        if (fullName && (declaringType = this.getDeclaringType()) != null) {
            return declaringType.appendName(sb, true, false).append('.').append(this.getName());
        }
        return sb.append(this._name);
    }

    protected StringBuilder appendDescription(StringBuilder sb) {
        StringBuilder s2 = sb;
        for (Modifier modifier : Flags.asModifierSet(this.getModifiers())) {
            s2.append(modifier.toString());
            s2.append(' ');
        }
        TypeReference fieldType = this.getFieldType();
        if (fieldType.isGenericParameter()) {
            s2.append(fieldType.getName());
        } else {
            s2 = fieldType.appendBriefDescription(s2);
        }
        s2.append(' ');
        s2.append(this.getName());
        return s2;
    }

    protected StringBuilder appendBriefDescription(StringBuilder sb) {
        StringBuilder s2 = sb;
        for (Modifier modifier : Flags.asModifierSet(this.getModifiers())) {
            s2.append(modifier.toString());
            s2.append(' ');
        }
        TypeReference fieldType = this.getFieldType();
        if (fieldType.isGenericParameter()) {
            s2.append(fieldType.getName());
        } else {
            s2 = fieldType.appendBriefDescription(s2);
        }
        s2.append(' ');
        s2.append(this.getName());
        return s2;
    }

    protected StringBuilder appendErasedDescription(StringBuilder sb) {
        StringBuilder s2 = sb;
        for (Modifier modifier : Flags.asModifierSet(this.getModifiers())) {
            s2.append(modifier.toString());
            s2.append(' ');
        }
        s2 = this.getFieldType().getRawType().appendErasedDescription(s2);
        s2.append(' ');
        s2.append(this.getName());
        return s2;
    }

    protected StringBuilder appendSimpleDescription(StringBuilder sb) {
        StringBuilder s2 = sb;
        for (Modifier modifier : Flags.asModifierSet(this.getModifiers())) {
            s2.append(modifier.toString());
            s2.append(' ');
        }
        TypeReference fieldType = this.getFieldType();
        if (fieldType.isGenericParameter()) {
            s2.append(fieldType.getName());
        } else {
            s2 = fieldType.appendSimpleDescription(s2);
        }
        s2.append(' ');
        s2.append(this.getName());
        return s2;
    }

    @Override
    public String toString() {
        return this.getSimpleDescription();
    }
}

