/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.assembler.ir;

import com.strobel.assembler.metadata.Buffer;
import com.strobel.assembler.metadata.FieldReference;
import com.strobel.assembler.metadata.MethodReference;
import com.strobel.assembler.metadata.TypeReference;
import com.strobel.core.Freezable;
import com.strobel.core.HashUtilities;
import com.strobel.core.StringUtilities;
import com.strobel.core.VerifyArgument;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

public final class ConstantPool
extends Freezable
implements Iterable<Entry> {
    private final ArrayList<Entry> _pool = new ArrayList();
    private final HashMap<Key, Entry> _entryMap = new HashMap();
    private final Key _lookupKey = new Key();
    private final Key _newKey = new Key();
    private int _size;

    @Override
    public Iterator<Entry> iterator() {
        return this._pool.iterator();
    }

    public void accept(Visitor visitor) {
        VerifyArgument.notNull(visitor, "visitor");
        for (Entry entry : this._pool) {
            if (entry == null) continue;
            visitor.visit(entry);
        }
    }

    public void write(Buffer stream) {
        stream.writeShort(this._size + 1);
        this.accept(new Writer(stream));
    }

    public <T extends Entry> T getEntry(int index) {
        VerifyArgument.inRange(0, this._size + 1, index, "index");
        Entry info = this._pool.get(index - 1);
        if (info == null) {
            throw new IndexOutOfBoundsException();
        }
        return (T)info;
    }

    public Entry get(int index) {
        VerifyArgument.inRange(0, this._size + 1, index, "index");
        Entry info = this._pool.get(index - 1);
        if (info == null) {
            throw new IndexOutOfBoundsException();
        }
        return info;
    }

    public Entry get(int index, Tag expectedType) {
        VerifyArgument.inRange(0, this._size + 1, index, "index");
        Entry entry = this.get(index);
        Tag actualType = entry.getTag();
        if (actualType != expectedType) {
            throw new IllegalStateException(String.format("Expected type '%s' but found type '%s'.", new Object[]{expectedType, actualType}));
        }
        return entry;
    }

    public String lookupStringConstant(int index) {
        StringConstantEntry entry = (StringConstantEntry)this.get(index, Tag.StringConstant);
        return entry.getValue();
    }

    public String lookupUtf8Constant(int index) {
        Utf8StringConstantEntry entry = (Utf8StringConstantEntry)this.get(index, Tag.Utf8StringConstant);
        return entry.value;
    }

    public <T> T lookupConstant(int index) {
        ConstantEntry entry = (ConstantEntry)this.get(index);
        return (T)entry.getConstantValue();
    }

    public int lookupIntegerConstant(int index) {
        IntegerConstantEntry entry = (IntegerConstantEntry)this.get(index, Tag.IntegerConstant);
        return entry.value;
    }

    public long lookupLongConstant(int index) {
        LongConstantEntry entry = (LongConstantEntry)this.get(index, Tag.LongConstant);
        return entry.value;
    }

    public float lookupFloatConstant(int index) {
        FloatConstantEntry entry = (FloatConstantEntry)this.get(index, Tag.FloatConstant);
        return entry.value;
    }

    public double lookupDoubleConstant(int index) {
        DoubleConstantEntry entry = (DoubleConstantEntry)this.get(index, Tag.DoubleConstant);
        return entry.value;
    }

    public Utf8StringConstantEntry getUtf8StringConstant(String value) {
        this._lookupKey.set(value);
        Entry entry = this._entryMap.get(this._lookupKey);
        if (entry == null) {
            if (this.isFrozen()) {
                return null;
            }
            entry = new Utf8StringConstantEntry(this, value);
        }
        this._lookupKey.clear();
        return (Utf8StringConstantEntry)entry;
    }

    public StringConstantEntry getStringConstant(String value) {
        Utf8StringConstantEntry utf8Constant = this.getUtf8StringConstant(value);
        this._lookupKey.set(Tag.StringConstant, utf8Constant.index);
        Entry entry = this._entryMap.get(this._lookupKey);
        if (entry == null) {
            if (this.isFrozen()) {
                return null;
            }
            entry = new StringConstantEntry(this, utf8Constant.index);
        }
        this._lookupKey.clear();
        return (StringConstantEntry)entry;
    }

    public IntegerConstantEntry getIntegerConstant(int value) {
        this._lookupKey.set(value);
        Entry entry = this._entryMap.get(this._lookupKey);
        if (entry == null) {
            if (this.isFrozen()) {
                return null;
            }
            entry = new IntegerConstantEntry(this, value);
        }
        this._lookupKey.clear();
        return (IntegerConstantEntry)entry;
    }

    public FloatConstantEntry getFloatConstant(float value) {
        this._lookupKey.set(value);
        Entry entry = this._entryMap.get(this._lookupKey);
        if (entry == null) {
            if (this.isFrozen()) {
                return null;
            }
            entry = new FloatConstantEntry(this, value);
        }
        this._lookupKey.clear();
        return (FloatConstantEntry)entry;
    }

    public LongConstantEntry getLongConstant(long value) {
        this._lookupKey.set(value);
        Entry entry = this._entryMap.get(this._lookupKey);
        if (entry == null) {
            if (this.isFrozen()) {
                return null;
            }
            entry = new LongConstantEntry(this, value);
        }
        this._lookupKey.clear();
        return (LongConstantEntry)entry;
    }

    public DoubleConstantEntry getDoubleConstant(double value) {
        this._lookupKey.set(value);
        Entry entry = this._entryMap.get(this._lookupKey);
        if (entry == null) {
            if (this.isFrozen()) {
                return null;
            }
            entry = new DoubleConstantEntry(this, value);
        }
        this._lookupKey.clear();
        return (DoubleConstantEntry)entry;
    }

    public TypeInfoEntry getTypeInfo(TypeReference type) {
        Utf8StringConstantEntry name = this.getUtf8StringConstant(type.getInternalName());
        this._lookupKey.set(Tag.TypeInfo, name.index);
        Entry entry = this._entryMap.get(this._lookupKey);
        if (entry == null) {
            if (this.isFrozen()) {
                return null;
            }
            entry = new TypeInfoEntry(this, name.index);
        }
        this._lookupKey.clear();
        return (TypeInfoEntry)entry;
    }

    public FieldReferenceEntry getFieldReference(FieldReference field) {
        TypeInfoEntry typeInfo = this.getTypeInfo(field.getDeclaringType());
        NameAndTypeDescriptorEntry nameAndDescriptor = this.getNameAndTypeDescriptor(field.getName(), field.getErasedSignature());
        this._lookupKey.set(Tag.FieldReference, typeInfo.index, nameAndDescriptor.index);
        Entry entry = this._entryMap.get(this._lookupKey);
        if (entry == null) {
            if (this.isFrozen()) {
                return null;
            }
            entry = new FieldReferenceEntry(this, typeInfo.index, nameAndDescriptor.index);
        }
        this._lookupKey.clear();
        return (FieldReferenceEntry)entry;
    }

    public MethodReferenceEntry getMethodReference(MethodReference method) {
        TypeInfoEntry typeInfo = this.getTypeInfo(method.getDeclaringType());
        NameAndTypeDescriptorEntry nameAndDescriptor = this.getNameAndTypeDescriptor(method.getName(), method.getErasedSignature());
        this._lookupKey.set(Tag.MethodReference, typeInfo.index, nameAndDescriptor.index);
        Entry entry = this._entryMap.get(this._lookupKey);
        if (entry == null) {
            if (this.isFrozen()) {
                return null;
            }
            entry = new MethodReferenceEntry(this, typeInfo.index, nameAndDescriptor.index);
        }
        this._lookupKey.clear();
        return (MethodReferenceEntry)entry;
    }

    public InterfaceMethodReferenceEntry getInterfaceMethodReference(MethodReference method) {
        TypeInfoEntry typeInfo = this.getTypeInfo(method.getDeclaringType());
        NameAndTypeDescriptorEntry nameAndDescriptor = this.getNameAndTypeDescriptor(method.getName(), method.getErasedSignature());
        this._lookupKey.set(Tag.InterfaceMethodReference, typeInfo.index, nameAndDescriptor.index);
        Entry entry = this._entryMap.get(this._lookupKey);
        if (entry == null) {
            if (this.isFrozen()) {
                return null;
            }
            entry = new InterfaceMethodReferenceEntry(this, typeInfo.index, nameAndDescriptor.index);
        }
        this._lookupKey.clear();
        return (InterfaceMethodReferenceEntry)entry;
    }

    NameAndTypeDescriptorEntry getNameAndTypeDescriptor(String name, String typeDescriptor) {
        Utf8StringConstantEntry utf8Name = this.getUtf8StringConstant(name);
        Utf8StringConstantEntry utf8Descriptor = this.getUtf8StringConstant(typeDescriptor);
        this._lookupKey.set(Tag.NameAndTypeDescriptor, utf8Name.index, utf8Descriptor.index);
        Entry entry = this._entryMap.get(this._lookupKey);
        if (entry == null) {
            if (this.isFrozen()) {
                return null;
            }
            entry = new NameAndTypeDescriptorEntry(this, utf8Name.index, utf8Descriptor.index);
        }
        this._lookupKey.clear();
        return (NameAndTypeDescriptorEntry)entry;
    }

    MethodHandleEntry getMethodHandle(ReferenceKind referenceKind, int referenceIndex) {
        this._lookupKey.set(Tag.MethodHandle, referenceIndex, referenceKind);
        Entry entry = this._entryMap.get(this._lookupKey);
        if (entry == null) {
            if (this.isFrozen()) {
                return null;
            }
            entry = new MethodHandleEntry(this, referenceKind, referenceIndex);
        }
        this._lookupKey.clear();
        return (MethodHandleEntry)entry;
    }

    MethodTypeEntry getMethodType(int descriptorIndex) {
        this._lookupKey.set(Tag.MethodType, descriptorIndex);
        Entry entry = this._entryMap.get(this._lookupKey);
        if (entry == null) {
            if (this.isFrozen()) {
                return null;
            }
            entry = new MethodTypeEntry(this, descriptorIndex);
        }
        this._lookupKey.clear();
        return (MethodTypeEntry)entry;
    }

    InvokeDynamicInfoEntry getInvokeDynamicInfo(int bootstrapMethodAttributeIndex, int nameAndTypeDescriptorIndex) {
        this._lookupKey.set(Tag.InvokeDynamicInfo, bootstrapMethodAttributeIndex, nameAndTypeDescriptorIndex);
        Entry entry = this._entryMap.get(this._lookupKey);
        if (entry == null) {
            if (this.isFrozen()) {
                return null;
            }
            entry = new InvokeDynamicInfoEntry(this, bootstrapMethodAttributeIndex, nameAndTypeDescriptorIndex);
        }
        this._lookupKey.clear();
        return (InvokeDynamicInfoEntry)entry;
    }

    public static ConstantPool read(Buffer b) {
        boolean skipOne = false;
        ConstantPool pool = new ConstantPool();
        int size = b.readUnsignedShort();
        Key key = new Key();
        block16: for (int i = 1; i < size; ++i) {
            if (skipOne) {
                skipOne = false;
                continue;
            }
            key.clear();
            Tag tag = Tag.fromValue(b.readUnsignedByte());
            switch (tag) {
                case Utf8StringConstant: {
                    new Utf8StringConstantEntry(pool, b.readUtf8());
                    continue block16;
                }
                case IntegerConstant: {
                    new IntegerConstantEntry(pool, b.readInt());
                    continue block16;
                }
                case FloatConstant: {
                    new FloatConstantEntry(pool, b.readFloat());
                    continue block16;
                }
                case LongConstant: {
                    new LongConstantEntry(pool, b.readLong());
                    skipOne = true;
                    continue block16;
                }
                case DoubleConstant: {
                    new DoubleConstantEntry(pool, b.readDouble());
                    skipOne = true;
                    continue block16;
                }
                case TypeInfo: {
                    new TypeInfoEntry(pool, b.readUnsignedShort());
                    continue block16;
                }
                case StringConstant: {
                    new StringConstantEntry(pool, b.readUnsignedShort());
                    continue block16;
                }
                case FieldReference: {
                    new FieldReferenceEntry(pool, b.readUnsignedShort(), b.readUnsignedShort());
                    continue block16;
                }
                case MethodReference: {
                    new MethodReferenceEntry(pool, b.readUnsignedShort(), b.readUnsignedShort());
                    continue block16;
                }
                case InterfaceMethodReference: {
                    new InterfaceMethodReferenceEntry(pool, b.readUnsignedShort(), b.readUnsignedShort());
                    continue block16;
                }
                case NameAndTypeDescriptor: {
                    new NameAndTypeDescriptorEntry(pool, b.readUnsignedShort(), b.readUnsignedShort());
                    continue block16;
                }
                case MethodHandle: {
                    new MethodHandleEntry(pool, ReferenceKind.fromTag(b.readUnsignedByte()), b.readUnsignedShort());
                    continue block16;
                }
                case MethodType: {
                    new MethodTypeEntry(pool, b.readUnsignedShort());
                    continue block16;
                }
                case InvokeDynamicInfo: {
                    new InvokeDynamicInfoEntry(pool, b.readUnsignedShort(), b.readUnsignedShort());
                }
            }
        }
        return pool;
    }

    private static final class Key {
        private Tag _tag;
        private int _intValue;
        private long _longValue;
        private String _stringValue1;
        private String _stringValue2;
        private int _refIndex1 = -1;
        private int _refIndex2 = -1;
        private int _hashCode;

        private Key() {
        }

        public void clear() {
            this._tag = null;
            this._intValue = 0;
            this._longValue = 0L;
            this._stringValue1 = null;
            this._stringValue2 = null;
            this._refIndex1 = -1;
            this._refIndex2 = -1;
        }

        public void set(int intValue) {
            this._tag = Tag.IntegerConstant;
            this._intValue = intValue;
            this._hashCode = Integer.MAX_VALUE & this._tag.value + this._intValue;
        }

        public void set(long longValue) {
            this._tag = Tag.LongConstant;
            this._longValue = longValue;
            this._hashCode = Integer.MAX_VALUE & this._tag.value + (int)longValue;
        }

        public void set(float floatValue) {
            this._tag = Tag.FloatConstant;
            this._intValue = Float.floatToIntBits(floatValue);
            this._hashCode = Integer.MAX_VALUE & this._tag.value + this._intValue;
        }

        public void set(double doubleValue) {
            this._tag = Tag.DoubleConstant;
            this._longValue = Double.doubleToLongBits(doubleValue);
            this._hashCode = Integer.MAX_VALUE & this._tag.value + (int)this._longValue;
        }

        public void set(String utf8Value) {
            this._tag = Tag.Utf8StringConstant;
            this._stringValue1 = utf8Value;
            this._hashCode = HashUtilities.combineHashCodes((Object)this._tag, (Object)utf8Value);
        }

        public void set(Tag tag, int refIndex1, ReferenceKind refKind) {
            this._tag = tag;
            this._refIndex1 = refIndex1;
            this._refIndex2 = refKind.tag;
            this._hashCode = HashUtilities.combineHashCodes((Object)tag, (Object)refIndex1);
        }

        public void set(Tag tag, int refIndex1) {
            this._tag = tag;
            this._refIndex1 = refIndex1;
            this._hashCode = HashUtilities.combineHashCodes((Object)tag, (Object)refIndex1);
        }

        public void set(Tag tag, int refIndex1, int refIndex2) {
            this._tag = tag;
            this._refIndex1 = refIndex1;
            this._refIndex2 = refIndex2;
            this._hashCode = HashUtilities.combineHashCodes((Object)tag, (Object)refIndex1, (Object)refIndex2);
        }

        public void set(Tag tag, String stringValue1) {
            this._tag = tag;
            this._stringValue1 = stringValue1;
            this._hashCode = HashUtilities.combineHashCodes((Object)tag, (Object)stringValue1);
        }

        public void set(Tag tag, String stringValue1, String stringValue2) {
            this._tag = tag;
            this._stringValue1 = stringValue1;
            this._stringValue2 = stringValue2;
            this._hashCode = HashUtilities.combineHashCodes((Object)tag, (Object)stringValue1, (Object)stringValue2);
        }

        protected Key clone() {
            Key key = new Key();
            key._tag = this._tag;
            key._hashCode = this._hashCode;
            key._intValue = this._intValue;
            key._longValue = this._longValue;
            key._stringValue1 = this._stringValue1;
            key._stringValue2 = this._stringValue2;
            key._refIndex1 = this._refIndex1;
            key._refIndex2 = this._refIndex2;
            return key;
        }

        public int hashCode() {
            return this._hashCode;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Key)) {
                return false;
            }
            Key key = (Key)obj;
            if (key._tag != this._tag) {
                return false;
            }
            switch (this._tag) {
                case Utf8StringConstant: {
                    return StringUtilities.equals(key._stringValue1, this._stringValue1);
                }
                case IntegerConstant: 
                case FloatConstant: {
                    return key._intValue == this._intValue;
                }
                case LongConstant: 
                case DoubleConstant: {
                    return key._longValue == this._longValue;
                }
                case TypeInfo: 
                case StringConstant: 
                case MethodType: {
                    return key._refIndex1 == this._refIndex1;
                }
                case FieldReference: 
                case MethodReference: 
                case InterfaceMethodReference: 
                case NameAndTypeDescriptor: 
                case MethodHandle: 
                case InvokeDynamicInfo: {
                    return key._refIndex1 == this._refIndex1 && key._refIndex2 == this._refIndex2;
                }
            }
            return false;
        }
    }

    public static final class Utf8StringConstantEntry
    extends ConstantEntry {
        public final String value;

        public Utf8StringConstantEntry(ConstantPool owner, String value) {
            super(owner);
            this.value = value;
            owner._newKey.set(this.getTag(), value);
            owner._entryMap.put(owner._newKey.clone(), this);
            owner._newKey.clear();
        }

        @Override
        void fixupKey(Key key) {
            key.set(this.value);
        }

        @Override
        public Tag getTag() {
            return Tag.Utf8StringConstant;
        }

        @Override
        public int byteLength() {
            class SizeOutputStream
            extends OutputStream {
                private int size;

                SizeOutputStream() {
                }

                @Override
                public void write(int b) {
                    ++this.size;
                }
            }
            SizeOutputStream sizeOut = new SizeOutputStream();
            DataOutputStream out = new DataOutputStream(sizeOut);
            try {
                out.writeUTF(this.value);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return 1 + sizeOut.size;
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.visitUtf8StringConstant(this);
        }

        public String toString() {
            return "Utf8StringConstantEntry[index: " + this.index + ", value: " + this.value + "]";
        }

        @Override
        public Object getConstantValue() {
            return this.value;
        }
    }

    public static final class StringConstantEntry
    extends ConstantEntry {
        public final int stringIndex;

        public StringConstantEntry(ConstantPool owner, int stringIndex) {
            super(owner);
            this.stringIndex = stringIndex;
            owner._newKey.set(this.getTag(), stringIndex);
            owner._entryMap.put(owner._newKey.clone(), this);
            owner._newKey.clear();
        }

        public String getValue() {
            return ((Utf8StringConstantEntry)this.owner.get((int)this.stringIndex)).value;
        }

        @Override
        void fixupKey(Key key) {
            key.set(Tag.StringConstant, this.stringIndex);
        }

        @Override
        public Tag getTag() {
            return Tag.StringConstant;
        }

        @Override
        public int byteLength() {
            return 3;
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.visitStringConstant(this);
        }

        public String toString() {
            return "StringConstantEntry[index: " + this.index + ", stringIndex: " + this.stringIndex + "]";
        }

        @Override
        public Object getConstantValue() {
            return this.getValue();
        }
    }

    public static final class LongConstantEntry
    extends ConstantEntry {
        public final long value;

        public LongConstantEntry(ConstantPool owner, long value) {
            super(owner);
            this.value = value;
            owner._newKey.set(value);
            owner._entryMap.put(owner._newKey.clone(), this);
            owner._newKey.clear();
        }

        @Override
        void fixupKey(Key key) {
            key.set(this.value);
        }

        @Override
        public Tag getTag() {
            return Tag.LongConstant;
        }

        @Override
        public int byteLength() {
            return 9;
        }

        @Override
        public int size() {
            return 2;
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.visitLongConstant(this);
        }

        public String toString() {
            return "LongConstantEntry[index: " + this.index + ", value: " + this.value + "]";
        }

        @Override
        public Object getConstantValue() {
            return this.value;
        }
    }

    public static final class IntegerConstantEntry
    extends ConstantEntry {
        public final int value;

        public IntegerConstantEntry(ConstantPool owner, int value) {
            super(owner);
            this.value = value;
            owner._newKey.set(value);
            owner._entryMap.put(owner._newKey.clone(), this);
            owner._newKey.clear();
        }

        @Override
        void fixupKey(Key key) {
            key.set(this.value);
        }

        @Override
        public Tag getTag() {
            return Tag.IntegerConstant;
        }

        @Override
        public int byteLength() {
            return 5;
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.visitIntegerConstant(this);
        }

        public String toString() {
            return "IntegerConstantEntry[index: " + this.index + ", value: " + this.value + "]";
        }

        @Override
        public Object getConstantValue() {
            return this.value;
        }
    }

    public static final class FloatConstantEntry
    extends ConstantEntry {
        public final float value;

        public FloatConstantEntry(ConstantPool owner, float value) {
            super(owner);
            this.value = value;
            owner._newKey.set(value);
            owner._entryMap.put(owner._newKey.clone(), this);
            owner._newKey.clear();
        }

        @Override
        void fixupKey(Key key) {
            key.set(this.value);
        }

        @Override
        public Tag getTag() {
            return Tag.FloatConstant;
        }

        @Override
        public int byteLength() {
            return 5;
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.visitFloatConstant(this);
        }

        public String toString() {
            return "FloatConstantEntry[index: " + this.index + ", value: " + this.value + "]";
        }

        @Override
        public Object getConstantValue() {
            return Float.valueOf(this.value);
        }
    }

    public static final class DoubleConstantEntry
    extends ConstantEntry {
        public final double value;

        public DoubleConstantEntry(ConstantPool owner, double value) {
            super(owner);
            this.value = value;
            owner._newKey.set(value);
            owner._entryMap.put(owner._newKey.clone(), this);
            owner._newKey.clear();
        }

        @Override
        void fixupKey(Key key) {
            key.set(this.value);
        }

        @Override
        public Tag getTag() {
            return Tag.DoubleConstant;
        }

        @Override
        public int size() {
            return 2;
        }

        @Override
        public int byteLength() {
            return 9;
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.visitDoubleConstant(this);
        }

        public String toString() {
            return "DoubleConstantEntry[index: " + this.index + ", value: " + this.value + "]";
        }

        @Override
        public Object getConstantValue() {
            return this.value;
        }
    }

    public static class InvokeDynamicInfoEntry
    extends Entry {
        public final int bootstrapMethodAttributeIndex;
        public final int nameAndTypeDescriptorIndex;

        public InvokeDynamicInfoEntry(ConstantPool owner, int bootstrapMethodAttributeIndex, int nameAndTypeDescriptorIndex) {
            super(owner);
            this.bootstrapMethodAttributeIndex = bootstrapMethodAttributeIndex;
            this.nameAndTypeDescriptorIndex = nameAndTypeDescriptorIndex;
            owner._newKey.set(this.getTag(), bootstrapMethodAttributeIndex, nameAndTypeDescriptorIndex);
            owner._entryMap.put(owner._newKey.clone(), this);
            owner._newKey.clear();
        }

        @Override
        void fixupKey(Key key) {
            key.set(Tag.InvokeDynamicInfo, this.bootstrapMethodAttributeIndex, this.nameAndTypeDescriptorIndex);
        }

        @Override
        public Tag getTag() {
            return Tag.InvokeDynamicInfo;
        }

        @Override
        public int byteLength() {
            return 5;
        }

        public NameAndTypeDescriptorEntry getNameAndTypeDescriptor() {
            return (NameAndTypeDescriptorEntry)this.owner.get(this.nameAndTypeDescriptorIndex, Tag.NameAndTypeDescriptor);
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.visitInvokeDynamicInfo(this);
        }

        public String toString() {
            return "InvokeDynamicInfoEntry[bootstrapMethodAttributeIndex: " + this.bootstrapMethodAttributeIndex + ", nameAndTypeDescriptorIndex: " + this.nameAndTypeDescriptorIndex + "]";
        }
    }

    public static class NameAndTypeDescriptorEntry
    extends Entry {
        public final int nameIndex;
        public final int typeDescriptorIndex;

        public NameAndTypeDescriptorEntry(ConstantPool owner, int nameIndex, int typeDescriptorIndex) {
            super(owner);
            this.nameIndex = nameIndex;
            this.typeDescriptorIndex = typeDescriptorIndex;
            owner._newKey.set(this.getTag(), nameIndex, typeDescriptorIndex);
            owner._entryMap.put(owner._newKey.clone(), this);
            owner._newKey.clear();
        }

        @Override
        void fixupKey(Key key) {
            key.set(Tag.NameAndTypeDescriptor, this.nameIndex, this.typeDescriptorIndex);
        }

        @Override
        public Tag getTag() {
            return Tag.NameAndTypeDescriptor;
        }

        @Override
        public int byteLength() {
            return 5;
        }

        public String getName() {
            return ((Utf8StringConstantEntry)this.owner.get((int)this.nameIndex, (Tag)Tag.Utf8StringConstant)).value;
        }

        public String getType() {
            return ((Utf8StringConstantEntry)this.owner.get((int)this.typeDescriptorIndex, (Tag)Tag.Utf8StringConstant)).value;
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.visitNameAndTypeDescriptor(this);
        }

        public String toString() {
            return "NameAndTypeDescriptorEntry[index: " + this.index + ", descriptorIndex: " + this.nameIndex + ", typeDescriptorIndex: " + this.typeDescriptorIndex + "]";
        }
    }

    public static class MethodHandleEntry
    extends Entry {
        public final ReferenceKind referenceKind;
        public final int referenceIndex;

        public MethodHandleEntry(ConstantPool owner, ReferenceKind referenceKind, int referenceIndex) {
            super(owner);
            this.referenceKind = referenceKind;
            this.referenceIndex = referenceIndex;
            owner._newKey.set(this.getTag(), referenceIndex, referenceKind);
            owner._entryMap.put(owner._newKey.clone(), this);
            owner._newKey.clear();
        }

        public ReferenceEntry getReference() {
            Tag actual = this.owner.get(this.referenceIndex).getTag();
            Tag expected = Tag.MethodReference;
            switch (actual) {
                case FieldReference: 
                case InterfaceMethodReference: {
                    expected = actual;
                }
            }
            return (ReferenceEntry)this.owner.get(this.referenceIndex, expected);
        }

        @Override
        void fixupKey(Key key) {
            key.set(Tag.MethodHandle, this.referenceIndex, this.referenceKind);
        }

        @Override
        public Tag getTag() {
            return Tag.MethodHandle;
        }

        @Override
        public int byteLength() {
            return 4;
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.visitMethodHandle(this);
        }
    }

    public static final class InterfaceMethodReferenceEntry
    extends ReferenceEntry {
        public InterfaceMethodReferenceEntry(ConstantPool owner, int typeIndex, int nameAndTypeDescriptorIndex) {
            super(owner, Tag.InterfaceMethodReference, typeIndex, nameAndTypeDescriptorIndex);
        }

        @Override
        void fixupKey(Key key) {
            key.set(Tag.InterfaceMethodReference, this.typeInfoIndex, this.nameAndTypeDescriptorIndex);
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.visitInterfaceMethodReference(this);
        }
    }

    public static final class MethodReferenceEntry
    extends ReferenceEntry {
        public MethodReferenceEntry(ConstantPool owner, int typeIndex, int nameAndTypeDescriptorIndex) {
            super(owner, Tag.MethodReference, typeIndex, nameAndTypeDescriptorIndex);
        }

        @Override
        void fixupKey(Key key) {
            key.set(Tag.MethodReference, this.typeInfoIndex, this.nameAndTypeDescriptorIndex);
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.visitMethodReference(this);
        }
    }

    public static final class FieldReferenceEntry
    extends ReferenceEntry {
        public FieldReferenceEntry(ConstantPool owner, int typeIndex, int nameAndTypeDescriptorIndex) {
            super(owner, Tag.FieldReference, typeIndex, nameAndTypeDescriptorIndex);
        }

        @Override
        void fixupKey(Key key) {
            key.set(Tag.FieldReference, this.typeInfoIndex, this.nameAndTypeDescriptorIndex);
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.visitFieldReference(this);
        }
    }

    public static abstract class ReferenceEntry
    extends Entry {
        public final Tag tag;
        public final int typeInfoIndex;
        public final int nameAndTypeDescriptorIndex;

        protected ReferenceEntry(ConstantPool cp, Tag tag, int typeInfoIndex, int nameAndTypeDescriptorIndex) {
            super(cp);
            this.tag = tag;
            this.typeInfoIndex = typeInfoIndex;
            this.nameAndTypeDescriptorIndex = nameAndTypeDescriptorIndex;
            this.owner._newKey.set(tag, typeInfoIndex, nameAndTypeDescriptorIndex);
            this.owner._entryMap.put(this.owner._newKey.clone(), this);
            this.owner._newKey.clear();
        }

        @Override
        public Tag getTag() {
            return this.tag;
        }

        @Override
        public int byteLength() {
            return 5;
        }

        public TypeInfoEntry getClassInfo() {
            return (TypeInfoEntry)this.owner.get(this.typeInfoIndex, Tag.TypeInfo);
        }

        public String getClassName() {
            return this.getClassInfo().getName();
        }

        public NameAndTypeDescriptorEntry getNameAndTypeInfo() {
            return (NameAndTypeDescriptorEntry)this.owner.get(this.nameAndTypeDescriptorIndex, Tag.NameAndTypeDescriptor);
        }

        public String toString() {
            return this.getClass().getSimpleName() + "[index: " + this.index + ", typeInfoIndex: " + this.typeInfoIndex + ", nameAndTypeDescriptorIndex: " + this.nameAndTypeDescriptorIndex + "]";
        }
    }

    public static final class MethodTypeEntry
    extends Entry {
        public final int descriptorIndex;

        public MethodTypeEntry(ConstantPool owner, int descriptorIndex) {
            super(owner);
            this.descriptorIndex = descriptorIndex;
            owner._newKey.set(this.getTag(), descriptorIndex);
            owner._entryMap.put(owner._newKey.clone(), this);
            owner._newKey.clear();
        }

        public String getType() {
            return ((Utf8StringConstantEntry)this.owner.get((int)this.descriptorIndex, (Tag)Tag.Utf8StringConstant)).value;
        }

        @Override
        void fixupKey(Key key) {
            key.set(Tag.MethodType, this.descriptorIndex);
        }

        @Override
        public Tag getTag() {
            return Tag.MethodType;
        }

        @Override
        public int byteLength() {
            return 3;
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.visitMethodType(this);
        }

        public String toString() {
            return "MethodTypeEntry[index: " + this.index + ", descriptorIndex: " + this.descriptorIndex + "]";
        }
    }

    public static final class TypeInfoEntry
    extends Entry {
        public final int nameIndex;

        public TypeInfoEntry(ConstantPool owner, int nameIndex) {
            super(owner);
            this.nameIndex = nameIndex;
            owner._newKey.set(this.getTag(), nameIndex);
            owner._entryMap.put(owner._newKey.clone(), this);
            owner._newKey.clear();
        }

        public String getName() {
            return ((Utf8StringConstantEntry)this.owner.get((int)this.nameIndex, (Tag)Tag.Utf8StringConstant)).value;
        }

        @Override
        void fixupKey(Key key) {
            key.set(Tag.TypeInfo, this.nameIndex);
        }

        @Override
        public Tag getTag() {
            return Tag.TypeInfo;
        }

        @Override
        public int byteLength() {
            return 3;
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.visitTypeInfo(this);
        }

        public String toString() {
            return "TypeIndex[index: " + this.index + ", nameIndex: " + this.nameIndex + "]";
        }
    }

    private static final class Writer
    implements Visitor {
        private final Buffer codeStream;

        private Writer(Buffer codeStream) {
            this.codeStream = VerifyArgument.notNull(codeStream, "codeStream");
        }

        @Override
        public void visit(Entry entry) {
            entry.accept(this);
        }

        @Override
        public void visitTypeInfo(TypeInfoEntry info) {
            this.codeStream.writeByte(info.getTag().value);
            this.codeStream.writeShort(info.nameIndex);
        }

        @Override
        public void visitDoubleConstant(DoubleConstantEntry info) {
            this.codeStream.writeByte(info.getTag().value);
            this.codeStream.writeDouble(info.value);
        }

        @Override
        public void visitFieldReference(FieldReferenceEntry info) {
            this.codeStream.writeByte(info.getTag().value);
            this.codeStream.writeShort(info.typeInfoIndex);
            this.codeStream.writeShort(info.nameAndTypeDescriptorIndex);
        }

        @Override
        public void visitFloatConstant(FloatConstantEntry info) {
            this.codeStream.writeByte(info.getTag().value);
            this.codeStream.writeFloat(info.value);
        }

        @Override
        public void visitIntegerConstant(IntegerConstantEntry info) {
            this.codeStream.writeByte(info.getTag().value);
            this.codeStream.writeInt(info.value);
        }

        @Override
        public void visitInterfaceMethodReference(InterfaceMethodReferenceEntry info) {
            this.codeStream.writeByte(info.getTag().value);
            this.codeStream.writeShort(info.typeInfoIndex);
            this.codeStream.writeShort(info.nameAndTypeDescriptorIndex);
        }

        @Override
        public void visitInvokeDynamicInfo(InvokeDynamicInfoEntry info) {
            this.codeStream.writeByte(info.getTag().value);
            this.codeStream.writeShort(info.bootstrapMethodAttributeIndex);
            this.codeStream.writeShort(info.nameAndTypeDescriptorIndex);
        }

        @Override
        public void visitLongConstant(LongConstantEntry info) {
            this.codeStream.writeByte(info.getTag().value);
            this.codeStream.writeLong(info.value);
        }

        @Override
        public void visitNameAndTypeDescriptor(NameAndTypeDescriptorEntry info) {
            this.codeStream.writeByte(info.getTag().value);
            this.codeStream.writeShort(info.nameIndex);
            this.codeStream.writeShort(info.typeDescriptorIndex);
        }

        @Override
        public void visitMethodReference(MethodReferenceEntry info) {
            this.codeStream.writeByte(info.getTag().value);
            this.codeStream.writeShort(info.typeInfoIndex);
            this.codeStream.writeShort(info.nameAndTypeDescriptorIndex);
        }

        @Override
        public void visitMethodHandle(MethodHandleEntry info) {
            this.codeStream.writeByte(info.getTag().value);
            this.codeStream.writeShort(info.referenceKind.ordinal());
            this.codeStream.writeShort(info.referenceIndex);
        }

        @Override
        public void visitMethodType(MethodTypeEntry info) {
            this.codeStream.writeByte(info.getTag().value);
            this.codeStream.writeShort(info.descriptorIndex);
        }

        @Override
        public void visitStringConstant(StringConstantEntry info) {
            this.codeStream.writeByte(info.getTag().value);
            this.codeStream.writeShort(info.stringIndex);
        }

        @Override
        public void visitUtf8StringConstant(Utf8StringConstantEntry info) {
            this.codeStream.writeByte(info.getTag().value);
            this.codeStream.writeUtf8(info.value);
        }

        @Override
        public void visitEnd() {
        }
    }

    public static interface Visitor {
        public static final Visitor EMPTY = new Visitor(){

            @Override
            public void visit(Entry entry) {
            }

            @Override
            public void visitTypeInfo(TypeInfoEntry info) {
            }

            @Override
            public void visitDoubleConstant(DoubleConstantEntry info) {
            }

            @Override
            public void visitFieldReference(FieldReferenceEntry info) {
            }

            @Override
            public void visitFloatConstant(FloatConstantEntry info) {
            }

            @Override
            public void visitIntegerConstant(IntegerConstantEntry info) {
            }

            @Override
            public void visitInterfaceMethodReference(InterfaceMethodReferenceEntry info) {
            }

            @Override
            public void visitInvokeDynamicInfo(InvokeDynamicInfoEntry info) {
            }

            @Override
            public void visitLongConstant(LongConstantEntry info) {
            }

            @Override
            public void visitNameAndTypeDescriptor(NameAndTypeDescriptorEntry info) {
            }

            @Override
            public void visitMethodReference(MethodReferenceEntry info) {
            }

            @Override
            public void visitMethodHandle(MethodHandleEntry info) {
            }

            @Override
            public void visitMethodType(MethodTypeEntry info) {
            }

            @Override
            public void visitStringConstant(StringConstantEntry info) {
            }

            @Override
            public void visitUtf8StringConstant(Utf8StringConstantEntry info) {
            }

            @Override
            public void visitEnd() {
            }
        };

        public void visit(Entry var1);

        public void visitTypeInfo(TypeInfoEntry var1);

        public void visitDoubleConstant(DoubleConstantEntry var1);

        public void visitFieldReference(FieldReferenceEntry var1);

        public void visitFloatConstant(FloatConstantEntry var1);

        public void visitIntegerConstant(IntegerConstantEntry var1);

        public void visitInterfaceMethodReference(InterfaceMethodReferenceEntry var1);

        public void visitInvokeDynamicInfo(InvokeDynamicInfoEntry var1);

        public void visitLongConstant(LongConstantEntry var1);

        public void visitNameAndTypeDescriptor(NameAndTypeDescriptorEntry var1);

        public void visitMethodReference(MethodReferenceEntry var1);

        public void visitMethodHandle(MethodHandleEntry var1);

        public void visitMethodType(MethodTypeEntry var1);

        public void visitStringConstant(StringConstantEntry var1);

        public void visitUtf8StringConstant(Utf8StringConstantEntry var1);

        public void visitEnd();
    }

    public static enum Tag {
        Utf8StringConstant(1),
        IntegerConstant(3),
        FloatConstant(4),
        LongConstant(5),
        DoubleConstant(6),
        TypeInfo(7),
        StringConstant(8),
        FieldReference(9),
        MethodReference(10),
        InterfaceMethodReference(11),
        NameAndTypeDescriptor(12),
        MethodHandle(15),
        MethodType(16),
        InvokeDynamicInfo(18);

        public final int value;
        private static final Tag[] lookup;

        private Tag(int value) {
            this.value = value;
        }

        public static Tag fromValue(int value) {
            VerifyArgument.inRange(Tag.Utf8StringConstant.value, Tag.InvokeDynamicInfo.value, value, "value");
            return lookup[value];
        }

        static {
            Tag[] values = Tag.values();
            lookup = new Tag[Tag.InvokeDynamicInfo.value + 1];
            Tag[] tagArray = values;
            int n = tagArray.length;
            for (int i = 0; i < n; ++i) {
                Tag tag;
                Tag.lookup[tag.value] = tag = tagArray[i];
            }
        }
    }

    public static enum ReferenceKind {
        GetField(1, "getfield"),
        GetStatic(2, "getstatic"),
        PutField(3, "putfield"),
        PutStatic(4, "putstatic"),
        InvokeVirtual(5, "invokevirtual"),
        InvokeStatic(6, "invokestatic"),
        InvokeSpecial(7, "invokespecial"),
        NewInvokeSpecial(8, "newinvokespecial"),
        InvokeInterface(9, "invokeinterface");

        public final int tag;
        public final String name;

        private ReferenceKind(int tag, String name) {
            this.tag = tag;
            this.name = name;
        }

        static ReferenceKind fromTag(int tag) {
            switch (tag) {
                case 1: {
                    return GetField;
                }
                case 2: {
                    return GetStatic;
                }
                case 3: {
                    return PutField;
                }
                case 4: {
                    return PutStatic;
                }
                case 5: {
                    return InvokeVirtual;
                }
                case 6: {
                    return InvokeStatic;
                }
                case 7: {
                    return InvokeSpecial;
                }
                case 8: {
                    return NewInvokeSpecial;
                }
                case 9: {
                    return InvokeInterface;
                }
            }
            return null;
        }
    }

    public static abstract class ConstantEntry
    extends Entry {
        ConstantEntry(ConstantPool owner) {
            super(owner);
        }

        public abstract Object getConstantValue();
    }

    public static abstract class Entry {
        public final int index;
        protected final ConstantPool owner;

        Entry(ConstantPool owner) {
            this.owner = owner;
            this.index = owner._size + 1;
            owner._pool.add(this);
            owner._size = owner._size + this.size();
            for (int i = 1; i < this.size(); ++i) {
                owner._pool.add(null);
            }
        }

        abstract void fixupKey(Key var1);

        public abstract Tag getTag();

        public int size() {
            return 1;
        }

        public abstract int byteLength();

        public abstract void accept(Visitor var1);
    }
}

