/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.command;

import cuchaz.enigma.EnigmaProject;
import cuchaz.enigma.ProgressListener;
import cuchaz.enigma.command.Command;
import java.nio.file.Path;

public class DeobfuscateCommand
extends Command {
    public DeobfuscateCommand() {
        super("deobfuscate");
    }

    @Override
    public String getUsage() {
        return "<in jar> <out jar> [<mappings file>]";
    }

    @Override
    public boolean isValidArgument(int length) {
        return length == 2 || length == 3;
    }

    @Override
    public void run(String ... args) throws Exception {
        Path fileJarIn = DeobfuscateCommand.getReadablePath(DeobfuscateCommand.getArg(args, 0, "in jar", true));
        Path fileJarOut = DeobfuscateCommand.getWritableFile(DeobfuscateCommand.getArg(args, 1, "out jar", true)).toPath();
        Path fileMappings = DeobfuscateCommand.getReadablePath(DeobfuscateCommand.getArg(args, 2, "mappings file", false));
        EnigmaProject project = DeobfuscateCommand.openProject(fileJarIn, fileMappings);
        Command.ConsoleProgressListener progress = new Command.ConsoleProgressListener();
        EnigmaProject.JarExport jar = project.exportRemappedJar((ProgressListener)progress);
        jar.write(fileJarOut, (ProgressListener)progress);
    }
}

