/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.command;

import cuchaz.enigma.EnigmaProject;
import cuchaz.enigma.ProgressListener;
import cuchaz.enigma.command.Command;
import cuchaz.enigma.source.DecompilerService;
import cuchaz.enigma.source.Decompilers;
import java.lang.reflect.Field;
import java.nio.file.Path;
import java.util.Locale;

public class DecompileCommand
extends Command {
    public DecompileCommand() {
        super("decompile");
    }

    @Override
    public String getUsage() {
        return "<decompiler> <in jar> <out folder> [<mappings file>]";
    }

    @Override
    public boolean isValidArgument(int length) {
        return length == 2 || length == 3;
    }

    @Override
    public void run(String ... args) throws Exception {
        DecompilerService decompilerService;
        String decompilerName = DecompileCommand.getArg(args, 1, "decompiler", true);
        Path fileJarIn = DecompileCommand.getReadableFile(DecompileCommand.getArg(args, 1, "in jar", true)).toPath();
        Path fileJarOut = DecompileCommand.getWritableFolder(DecompileCommand.getArg(args, 2, "out folder", true)).toPath();
        Path fileMappings = DecompileCommand.getReadablePath(DecompileCommand.getArg(args, 3, "mappings file", false));
        try {
            Field decompilerField = Decompilers.class.getField(decompilerName.toUpperCase(Locale.ROOT));
            decompilerService = (DecompilerService)decompilerField.get(null);
        }
        catch (NoSuchFieldException e) {
            System.err.println("Decompiler not found.");
            return;
        }
        EnigmaProject project = DecompileCommand.openProject(fileJarIn, fileMappings);
        Command.ConsoleProgressListener progress = new Command.ConsoleProgressListener();
        EnigmaProject.JarExport jar = project.exportRemappedJar((ProgressListener)progress);
        EnigmaProject.SourceExport source = jar.decompile((ProgressListener)progress, decompilerService);
        source.write(fileJarOut, (ProgressListener)progress);
    }
}

