/*
 * This file is part of TechReborn, licensed under the MIT License (MIT).
 *
 * Copyright (c) 2020 TechReborn
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package techreborn.world;

import net.fabricmc.fabric.api.biome.v1.BiomeModificationContext;
import net.fabricmc.fabric.api.biome.v1.BiomeModifications;
import net.fabricmc.fabric.api.biome.v1.BiomeSelectionContext;
import net.fabricmc.fabric.api.biome.v1.BiomeSelectors;
import net.fabricmc.fabric.api.biome.v1.ModificationPhase;
import net.minecraft.class_1972;
import net.minecraft.class_2378;
import net.minecraft.class_2893;
import net.minecraft.class_2960;
import net.minecraft.class_2975;
import net.minecraft.class_4663;
import net.minecraft.class_5321;
import net.minecraft.class_6796;
import net.minecraft.class_6908;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_8813;
import techreborn.config.TechRebornConfig;
import techreborn.init.TRContent;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;

// /fill ~ ~ ~ ~20 ~20 ~20 air replace #minecraft:base_stone_overworld
public class WorldGenerator {
	public static final List<TROreFeatureConfig> ORE_FEATURES = getOreFeatures();

	public static final class_2960 OIL_LAKE_ID = class_2960.method_60655("techreborn", "oil_lake");
	public static final class_5321<class_2975<?, ?>> OIL_LAKE_FEATURE = class_5321.method_29179(class_7924.field_41239, OIL_LAKE_ID);
	public static final class_5321<class_6796> OIL_LAKE_PLACED_FEATURE = class_5321.method_29179(class_7924.field_41245, OIL_LAKE_ID);

	public static final class_2960 RUBBER_TREE_ID = class_2960.method_60655("techreborn", "rubber_tree");
	public static final class_5321<class_2975<?, ?>> RUBBER_TREE_FEATURE = class_5321.method_29179(class_7924.field_41239, RUBBER_TREE_ID);
	public static final class_5321<class_6796> RUBBER_TREE_PLACED_FEATURE = class_5321.method_29179(class_7924.field_41245, RUBBER_TREE_ID);

	public static final class_2960 RUBBER_TREE_PATCH_ID = class_2960.method_60655("techreborn", "rubber_tree_patch");
	public static final class_5321<class_2975<?, ?>> RUBBER_TREE_PATCH_FEATURE = class_5321.method_29179(class_7924.field_41239, RUBBER_TREE_PATCH_ID);
	public static final class_5321<class_6796> RUBBER_TREE_PATCH_PLACED_FEATURE = class_5321.method_29179(class_7924.field_41245, RUBBER_TREE_PATCH_ID);

	public static final class_4663<RubberTreeSpikeDecorator> RUBBER_TREE_SPIKE = class_2378.method_10230(class_7923.field_41153, class_2960.method_60655("techreborn", "rubber_tree_spike"), new class_4663<>(RubberTreeSpikeDecorator.CODEC));

	public static final class_8813 RUBBER_TREE_SAPLING_GENERATOR = new class_8813(
		class_2960.method_60655("techreborn", "rubber_tree").toString(),
		Optional.empty(),
		Optional.of(RUBBER_TREE_FEATURE),
		Optional.empty()
	);

	public static void initWorldGen() {
		if (!TechRebornConfig.enableOreGeneration && !TechRebornConfig.enableRubberTreeGeneration && !TechRebornConfig.enableOilLakeGeneration) {
			return;
		}

		BiomeModifications.create(class_2960.method_60655("techreborn", "features"))
				.add(ModificationPhase.ADDITIONS, BiomeSelectors.all(), oreModifier())
				.add(ModificationPhase.ADDITIONS, BiomeSelectors.tag(class_6908.field_36517)
					.or(BiomeSelectors.tag(class_6908.field_36515))
					.or(BiomeSelectors.includeByKey(class_1972.field_9471)), rubberTreeModifier())
				.add(ModificationPhase.ADDITIONS, BiomeSelectors.tag(class_6908.field_37393), oilLakeModifier());
	}

	private static BiConsumer<BiomeSelectionContext, BiomeModificationContext> oreModifier() {
		return (biomeSelectionContext, biomeModificationContext) -> {
			if (!TechRebornConfig.enableOreGeneration) {
				return;
			}

			for (TROreFeatureConfig feature : ORE_FEATURES) {
				if (feature.biomeSelector().test(biomeSelectionContext)) {
					biomeModificationContext.getGenerationSettings().addFeature(class_2893.class_2895.field_13176, feature.placedFeature());
				}
			}
		};
	}

	private static List<TROreFeatureConfig> getOreFeatures() {
		return Arrays.stream(TRContent.Ores.values())
				.filter(ores -> ores.distribution != null)
				.filter(ores -> ores.distribution.isGenerating())
				.map(TROreFeatureConfig::of)
				.toList();
	}

	private static BiConsumer<BiomeSelectionContext, BiomeModificationContext> rubberTreeModifier() {
		if (!TechRebornConfig.enableRubberTreeGeneration) {
			return (biomeSelectionContext, biomeModificationContext) -> {};
		}

		return (biomeSelectionContext, biomeModificationContext) ->
				biomeModificationContext.getGenerationSettings().addFeature(class_2893.class_2895.field_13178, RUBBER_TREE_PATCH_PLACED_FEATURE);
	}

	private static Consumer<BiomeModificationContext> oilLakeModifier(){
		if (!TechRebornConfig.enableOilLakeGeneration) {
			return (biomeModificationContext) -> {};
		}

		return (biomeModificationContext) -> biomeModificationContext.getGenerationSettings().addFeature(class_2893.class_2895.field_25186, OIL_LAKE_PLACED_FEATURE);
	}
}
