/*
 * This file is part of TechReborn, licensed under the MIT License (MIT).
 *
 * Copyright (c) 2020 TechReborn
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package techreborn.world;

import io.netty.buffer.ByteBuf;
import net.fabricmc.fabric.api.biome.v1.BiomeSelectionContext;
import net.fabricmc.fabric.api.biome.v1.BiomeSelectors;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import java.util.function.Predicate;

public enum TargetDimension {
	OVERWORLD(BiomeSelectors.foundInOverworld()),
	NETHER(BiomeSelectors.foundInTheNether()),
	END(BiomeSelectors.foundInTheEnd());

	public static final class_9139<ByteBuf, TargetDimension> PACKET_CODEC = class_9135.field_49675
		.method_56432(integer -> TargetDimension.values()[integer], Enum::ordinal);

	public final Predicate<BiomeSelectionContext> biomeSelector;

	TargetDimension(Predicate<BiomeSelectionContext> biomeSelector) {
		this.biomeSelector = biomeSelector;
	}
}
