/*
 * This file is part of TechReborn, licensed under the MIT License (MIT).
 *
 * Copyright (c) 2020 TechReborn
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package techreborn.world;

import net.fabricmc.fabric.api.biome.v1.BiomeSelectionContext;
import net.minecraft.class_2960;
import net.minecraft.class_2975;
import net.minecraft.class_5321;
import net.minecraft.class_6796;
import net.minecraft.class_7924;
import techreborn.init.TRContent;

import java.util.function.Predicate;

public record TROreFeatureConfig(class_2960 id, TRContent.Ores ore, class_5321<class_2975<?, ?>> configuredFeature, class_5321<class_6796> placedFeature) {
	public static TROreFeatureConfig of(TRContent.Ores ore) {
		class_2960 id = class_2960.method_60655("techreborn", ore.name + "_ore");
		return new TROreFeatureConfig(
			id,
			ore,
			class_5321.method_29179(class_7924.field_41239, id),
			class_5321.method_29179(class_7924.field_41245, id)
		);
	}

	public Predicate<BiomeSelectionContext> biomeSelector() {
		return ore.distribution.dimension.biomeSelector;
	}
}
