/*
 * This file is part of TechReborn, licensed under the MIT License (MIT).
 *
 * Copyright (c) 2020 TechReborn
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package techreborn.world;

import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import techreborn.init.TRContent;

import java.util.Comparator;
import net.minecraft.class_2338;
import net.minecraft.class_3481;
import net.minecraft.class_4651;
import net.minecraft.class_4662;
import net.minecraft.class_4663;

public class RubberTreeSpikeDecorator  extends class_4662 {
	public static final MapCodec<RubberTreeSpikeDecorator> CODEC = RecordCodecBuilder.mapCodec(instance ->
		instance.group(
			Codec.INT.fieldOf("spire_height").forGetter(RubberTreeSpikeDecorator::getSpireHeight),
			class_4651.field_24937.fieldOf("provider").forGetter(RubberTreeSpikeDecorator::getProvider)
		).apply(instance, RubberTreeSpikeDecorator::new)
	);

	private final int spireHeight;
	private final class_4651 provider;

	public RubberTreeSpikeDecorator(int spireHeight, class_4651 spireBlockState) {
		this.spireHeight = spireHeight;
		this.provider = spireBlockState;
	}

	@Override
	protected class_4663<?> method_28893() {
		return WorldGenerator.RUBBER_TREE_SPIKE;
	}

	@Override
	public void method_23469(class_7402 generator) {
		generator.method_43321().stream()
			.max(Comparator.comparingInt(class_2338::method_10264))
			.ifPresent(blockPos -> {
				for (int i = 0; i < spireHeight; i++) {
					class_2338 sPos = blockPos.method_10086(i);
					if (!generator.method_43316().method_16358(sPos, state -> state.method_26215() || state.method_27852(TRContent.RUBBER_LOG) || state.method_26164(class_3481.field_44470))) {
						return;
					}
					generator.method_43318(sPos, provider.method_23455(generator.method_43320(), sPos));
				}
			});
	}

	public int getSpireHeight() {
		return spireHeight;
	}

	public class_4651 getProvider() {
		return provider;
	}
}
