/*
 * This file is part of TechReborn, licensed under the MIT License (MIT).
 *
 * Copyright (c) 2020 TechReborn
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package techreborn.world;

import io.netty.buffer.ByteBuf;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_5321;
import net.minecraft.class_5868;
import net.minecraft.class_7923;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;
import techreborn.init.TRContent;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/**
 * Client synced DTO for ore depth
 */
public record OreDepth(class_2960 identifier, int minY, int maxY, TargetDimension dimension) {
	public static final class_9139<ByteBuf, OreDepth> PACKET_CODEC = class_9139.method_56905(
		class_2960.field_48267, OreDepth::identifier,
		class_9135.field_49675, OreDepth::minY,
		class_9135.field_49675, OreDepth::maxY,
		TargetDimension.PACKET_CODEC, OreDepth::dimension,
		OreDepth::new
	);

	public static List<OreDepth> create(MinecraftServer server) {

		final List<OreDepth> depths = new ArrayList<>();

		for (TRContent.Ores ore : TRContent.Ores.values()) {
			if (ore.isDeepslate()) continue;

			if (ore.distribution != null) {
				final class_2960 blockId = class_7923.field_41175.method_10221(ore.block);
				final class_5868 heightContext = getHeightContext(server, ore.distribution.dimension);

				if (heightContext == null) {
					continue;
				}

				final int minY = ore.distribution.minOffset.method_33844(heightContext);
				final int maxY = ore.distribution.maxY;

				depths.add(new OreDepth(blockId, minY, maxY, ore.distribution.dimension));

				TRContent.Ores deepslate = ore.getDeepslate();
				if (deepslate == null) continue;

				final class_2960 deepSlateBlockId = class_7923.field_41175.method_10221(deepslate.block);
				depths.add(new OreDepth(deepSlateBlockId, minY, maxY, ore.distribution.dimension));
			}
		}

		return Collections.unmodifiableList(depths);
	}

	@Nullable
	private static class_5868 getHeightContext(MinecraftServer server, TargetDimension dimension) {
		class_5321<class_1937> key = switch (dimension) {
			case OVERWORLD -> class_1937.field_25179;
			case NETHER ->  class_1937.field_25180;
			case END ->  class_1937.field_25181;
		};

		final class_3218 world = server.method_3847(key);

		if (world == null) {
			return null;
		}

		return new class_5868(world.method_14178().method_12129(), world);
	}
}
