/*
 * This file is part of TechReborn, licensed under the MIT License (MIT).
 *
 * Copyright (c) 2020 TechReborn
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package techreborn.utils;

import reborncore.api.events.ItemCraftCallback;
import reborncore.common.powerSystem.RcEnergyItem;
import techreborn.TechReborn;

import java.util.stream.IntStream;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_8566;
import net.minecraft.class_9304;
import net.minecraft.class_9334;

public final class PoweredCraftingHandler implements ItemCraftCallback {

	private PoweredCraftingHandler() {
	}

	public static void setup() {
		ItemCraftCallback.EVENT.register(new PoweredCraftingHandler());
	}

	@Override
	public void onCraft(class_1799 stack, class_8566 craftingInventory, class_1657 playerEntity) {
		if (stack.method_7909() instanceof RcEnergyItem energyItem) {
			long totalEnergy = IntStream.range(0, craftingInventory.method_5439())
					.mapToObj(craftingInventory::method_5438)
					.filter(s -> !s.method_7960())
					.mapToLong(s -> {
						if (s.method_7909() instanceof RcEnergyItem inputItem) {
							return inputItem.getStoredEnergy(s);
						} else {
							return 0;
						}
					})
					.sum();

			energyItem.setStoredEnergy(stack, Math.min(totalEnergy, energyItem.getEnergyCapacity(stack)));
		}

		if (!class_7923.field_41178.method_10221(stack.method_7909()).method_12836().equalsIgnoreCase(TechReborn.MOD_ID)) {
			return;
		}

		class_9304.class_9305 builder = new class_9304.class_9305(class_9304.field_49385);

		boolean didEnchant = false;

		for (int i = 0; i < craftingInventory.method_5439(); i++) {
			class_1799 ingredient = craftingInventory.method_5438(i);
			if (ingredient.method_7960()) {
				continue;
			}
			class_9304 existing = stack.method_58695(class_9334.field_49633, class_9304.field_49385);

			for (class_6880<class_1887> enchantment : existing.method_57534()) {
				builder.method_57550(enchantment, existing.method_57536(enchantment));
				didEnchant = true;
			}
		}

		if (didEnchant) {
			class_1890.method_57530(stack, builder.method_57549());
		}
	}

}
